/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.server.util.TranslatedValueMapView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=60L)
public class TranslatedValueMapViewTest {
    private static Map<String, Integer> createTestMap() {
        TreeMap<String, Integer> testMap = new TreeMap<String, Integer>();
        testMap.put("foo", 2);
        testMap.put("bar", 3);
        testMap.put("baz", 5);
        return testMap;
    }

    @Test
    public void testContains() {
        Map<String, Integer> underlying = TranslatedValueMapViewTest.createTestMap();
        TranslatedValueMapView view = new TranslatedValueMapView(underlying, v -> v.toString());
        Assertions.assertTrue((boolean)view.containsKey((Object)"foo"));
        Assertions.assertTrue((boolean)view.containsKey((Object)"bar"));
        Assertions.assertTrue((boolean)view.containsKey((Object)"baz"));
        Assertions.assertFalse((boolean)view.containsKey((Object)"quux"));
        underlying.put("quux", 101);
        Assertions.assertTrue((boolean)view.containsKey((Object)"quux"));
    }

    @Test
    public void testIsEmptyAndSize() {
        HashMap<String, Integer> underlying = new HashMap<String, Integer>();
        TranslatedValueMapView view = new TranslatedValueMapView(underlying, v -> v.toString());
        Assertions.assertTrue((boolean)view.isEmpty());
        Assertions.assertEquals((int)0, (int)view.size());
        underlying.put("quux", 101);
        Assertions.assertFalse((boolean)view.isEmpty());
        Assertions.assertEquals((int)1, (int)view.size());
    }

    @Test
    public void testGet() {
        Map<String, Integer> underlying = TranslatedValueMapViewTest.createTestMap();
        TranslatedValueMapView view = new TranslatedValueMapView(underlying, v -> v.toString());
        Assertions.assertEquals((Object)"2", (Object)view.get((Object)"foo"));
        Assertions.assertEquals((Object)"3", (Object)view.get((Object)"bar"));
        Assertions.assertEquals((Object)"5", (Object)view.get((Object)"baz"));
        Assertions.assertNull((Object)view.get((Object)"quux"));
        underlying.put("quux", 101);
        Assertions.assertEquals((Object)"101", (Object)view.get((Object)"quux"));
    }

    @Test
    public void testEntrySet() {
        Map<String, Integer> underlying = TranslatedValueMapViewTest.createTestMap();
        TranslatedValueMapView view = new TranslatedValueMapView(underlying, v -> v.toString());
        Assertions.assertEquals((int)3, (int)view.entrySet().size());
        Assertions.assertFalse((boolean)view.entrySet().isEmpty());
        Assertions.assertTrue((boolean)view.entrySet().contains(new AbstractMap.SimpleImmutableEntry<String, String>("foo", "2")));
        Assertions.assertFalse((boolean)view.entrySet().contains(new AbstractMap.SimpleImmutableEntry<String, String>("bar", "4")));
    }

    @Test
    public void testEntrySetIterator() {
        Map<String, Integer> underlying = TranslatedValueMapViewTest.createTestMap();
        TranslatedValueMapView view = new TranslatedValueMapView(underlying, v -> v.toString());
        Iterator iterator = view.entrySet().iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<String, String>("bar", "3"), iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<String, String>("baz", "5"), iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<String, String>("foo", "2"), iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }
}

