/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.idp.SamlIdPSessionManager;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;

public class SamlIdPMultifactorAuthenticationTrigger
implements MultifactorAuthenticationTrigger {
    private final ObjectProvider<SamlProfileHandlerConfigurationContext> contextProvider;

    public Optional<MultifactorAuthenticationProvider> isActivated(Authentication authentication, RegisteredService registeredService, HttpServletRequest request, HttpServletResponse response, Service service) {
        SamlProfileHandlerConfigurationContext context = (SamlProfileHandlerConfigurationContext)this.contextProvider.getObject();
        JEEContext webContext = new JEEContext(request, response);
        Optional result = SamlIdPSessionManager.of((OpenSamlConfigBean)context.getOpenSamlConfigBean(), (SessionStore)context.getSessionStore()).fetch((WebContext)webContext, AuthnRequest.class);
        Map<String, String> mappings = this.getAuthenticationContextMappings();
        return result.filter(pair -> registeredService instanceof SamlRegisteredService && pair.getLeft() instanceof AuthnRequest).filter(pair -> SamlIdPMultifactorAuthenticationTrigger.isAuthnRequestSigned((SamlRegisteredService)registeredService, request, (AuthnRequest)pair.getLeft(), (MessageContext)pair.getRight(), context)).map(pair -> (AuthnRequest)pair.getLeft()).flatMap(authnRequest -> authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs().stream().filter(Objects::nonNull).filter(ref -> StringUtils.isNotBlank((CharSequence)ref.getURI())).filter(ref -> {
            String clazz = ref.getURI();
            return mappings.containsKey(clazz);
        }).findFirst().map(mapped -> (String)mappings.get(mapped.getURI()))).flatMap(id -> {
            Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)context.getOpenSamlConfigBean().getApplicationContext());
            return MultifactorAuthenticationUtils.resolveProvider((Map)providerMap, (String)id);
        });
    }

    private static Boolean isAuthnRequestSigned(SamlRegisteredService registeredService, HttpServletRequest request, AuthnRequest authnRequest, MessageContext messageContext, SamlProfileHandlerConfigurationContext context) {
        boolean isSigned;
        boolean bl = isSigned = authnRequest.isSigned() || SAMLBindingSupport.isMessageSigned((MessageContext)messageContext);
        if (isSigned) {
            String entityId = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
            SamlRegisteredServiceMetadataAdaptor adaptor = (SamlRegisteredServiceMetadataAdaptor)SamlRegisteredServiceMetadataAdaptor.get((SamlRegisteredServiceCachingMetadataResolver)context.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (String)entityId).orElseThrow();
            return (Boolean)FunctionUtils.doAndHandle(() -> context.getSamlObjectSignatureValidator().verifySamlProfileRequest((RequestAbstractType)authnRequest, adaptor, request, messageContext));
        }
        return false;
    }

    public boolean supports(HttpServletRequest request, RegisteredService registeredService, Authentication authentication, Service service) {
        if (!this.getAuthenticationContextMappings().isEmpty() && registeredService instanceof SamlRegisteredService) {
            HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
            SamlProfileHandlerConfigurationContext context = (SamlProfileHandlerConfigurationContext)this.contextProvider.getObject();
            JEEContext webContext = new JEEContext(request, response);
            Optional result = SamlIdPSessionManager.of((OpenSamlConfigBean)context.getOpenSamlConfigBean(), (SessionStore)context.getSessionStore()).fetch((WebContext)webContext, AuthnRequest.class);
            if (result.isPresent()) {
                AuthnRequest authnRequest = (AuthnRequest)((Pair)result.get()).getLeft();
                return authnRequest.getRequestedAuthnContext() != null && authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs() != null && !authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs().isEmpty();
            }
        }
        return false;
    }

    protected Map<String, String> getAuthenticationContextMappings() {
        List authnContexts = ((SamlProfileHandlerConfigurationContext)this.contextProvider.getObject()).getCasProperties().getAuthn().getSamlIdp().getCore().getContext().getAuthenticationContextClassMappings();
        return CollectionUtils.convertDirectedListToMap((Collection)authnContexts);
    }

    @Generated
    public SamlIdPMultifactorAuthenticationTrigger(ObjectProvider<SamlProfileHandlerConfigurationContext> contextProvider) {
        this.contextProvider = contextProvider;
    }
}

