/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.shibboleth.shared.xml.SerializeSupport;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPLogoutProperties;
import org.apereo.cas.logout.LogoutRedirectionResponse;
import org.apereo.cas.logout.LogoutRedirectionStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.util.Saml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPHttpRedirectDeflateEncoder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.ext.saml2aslo.Asynchronous;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SamlIdPSingleLogoutRedirectionStrategy
implements LogoutRedirectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSingleLogoutRedirectionStrategy.class);
    private final SamlProfileHandlerConfigurationContext configurationContext;

    public int getOrder() {
        return 0;
    }

    public boolean supports(HttpServletRequest request, HttpServletResponse response) {
        RegisteredService registeredService = WebUtils.getRegisteredService((HttpServletRequest)request);
        if (registeredService instanceof SamlRegisteredService) {
            SamlRegisteredService samlRegisteredService = (SamlRegisteredService)registeredService;
            SamlIdPLogoutProperties logout = this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getLogout();
            String sloRequest = WebUtils.getSingleLogoutRequest((HttpServletRequest)request);
            boolean async = false;
            if (StringUtils.isNotBlank((CharSequence)sloRequest)) {
                async = this.getLogoutRequest(request).map(RequestAbstractType::getExtensions).stream().filter(Objects::nonNull).anyMatch(extensions -> !extensions.getUnknownXMLObjects(Asynchronous.DEFAULT_ELEMENT_NAME).isEmpty());
            }
            return logout.isSendLogoutResponse() && samlRegisteredService.isLogoutResponseEnabled() && sloRequest != null && !async;
        }
        return false;
    }

    public LogoutRedirectionResponse handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SamlRegisteredService samlRegisteredService = (SamlRegisteredService)WebUtils.getRegisteredService((HttpServletRequest)request);
        LogoutRequest samlLogoutRequest = this.getLogoutRequest(request).orElseThrow();
        String logoutRequestIssuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)samlLogoutRequest);
        Optional adaptorRes = SamlRegisteredServiceMetadataAdaptor.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)samlRegisteredService, (String)logoutRequestIssuer);
        if (adaptorRes.isEmpty()) {
            LOGGER.warn("Cannot find service provider metadata entity linked to [{}]", (Object)logoutRequestIssuer);
            return null;
        }
        SamlRegisteredServiceMetadataAdaptor adaptor = (SamlRegisteredServiceMetadataAdaptor)adaptorRes.get();
        String binding = this.determineLogoutResponseBindingType(adaptor, samlRegisteredService);
        LOGGER.debug("Logout response binding type is determined as [{}]", (Object)binding);
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(binding)) {
            return this.handleSingleLogoutForPostBinding(samlLogoutRequest, samlRegisteredService, adaptor, request, response);
        }
        return this.handleSingleLogoutForRedirectBinding(samlLogoutRequest, samlRegisteredService, adaptor, request, response);
    }

    protected String determineLogoutResponseBindingType(SamlRegisteredServiceMetadataAdaptor adaptor, SamlRegisteredService samlRegisteredService) {
        SamlIdPLogoutProperties logout = this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getLogout();
        String binding = logout.getLogoutResponseBinding();
        if (StringUtils.isNotBlank((CharSequence)samlRegisteredService.getLogoutResponseBinding())) {
            binding = samlRegisteredService.getLogoutResponseBinding();
        } else if (!adaptor.getSingleLogoutServices().isEmpty()) {
            binding = adaptor.getSingleLogoutService().getBinding();
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)binding, (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
    }

    protected LogoutRedirectionResponse handleSingleLogoutForRedirectBinding(LogoutRequest samlLogoutRequest, SamlRegisteredService samlRegisteredService, SamlRegisteredServiceMetadataAdaptor adaptor, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SingleLogoutService sloService = adaptor.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        return this.produceSamlLogoutResponseRedirect(adaptor, sloService, samlRegisteredService, samlLogoutRequest, request, response);
    }

    protected LogoutRedirectionResponse handleSingleLogoutForPostBinding(LogoutRequest samlLogoutRequest, SamlRegisteredService samlRegisteredService, SamlRegisteredServiceMetadataAdaptor adaptor, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SingleLogoutService sloService = adaptor.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        return this.produceSamlLogoutResponsePost(adaptor, sloService, samlRegisteredService, samlLogoutRequest, request, response);
    }

    protected LogoutRedirectionResponse produceSamlLogoutResponseRedirect(SamlRegisteredServiceMetadataAdaptor adaptor, SingleLogoutService sloService, SamlRegisteredService registeredService, LogoutRequest logoutRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LogoutResponse logoutResponse = this.buildSamlLogoutResponse(adaptor, sloService, registeredService, logoutRequest, request, response);
        String location = StringUtils.isBlank((CharSequence)sloService.getResponseLocation()) ? sloService.getLocation() : sloService.getResponseLocation();
        LOGGER.trace("Encoding logout response given endpoint [{}] for binding [{}]", (Object)location, (Object)sloService.getBinding());
        SamlIdPHttpRedirectDeflateEncoder encoder = new SamlIdPHttpRedirectDeflateEncoder(location, (SignableXMLObject)logoutResponse);
        encoder.setRelayState(request.getParameter("RelayState"));
        encoder.doEncode();
        String redirectUrl = encoder.getRedirectUrl();
        LOGGER.debug("Final logout redirect URL is [{}]", (Object)redirectUrl);
        WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)redirectUrl);
        return null;
    }

    protected LogoutRedirectionResponse produceSamlLogoutResponsePost(SamlRegisteredServiceMetadataAdaptor adaptor, SingleLogoutService sloService, SamlRegisteredService registeredService, LogoutRequest logoutRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LogoutResponse logoutResponse = this.buildSamlLogoutResponse(adaptor, sloService, registeredService, logoutRequest, request, response);
        String location = StringUtils.isBlank((CharSequence)sloService.getResponseLocation()) ? sloService.getLocation() : sloService.getResponseLocation();
        LOGGER.debug("Encoding logout response for endpoint [{}] and binding [{}]", (Object)location, (Object)sloService.getBinding());
        String payload = SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)logoutResponse));
        LOGGER.debug("Logout response payload is [{}]", (Object)payload);
        String message = EncodingUtils.encodeBase64((String)payload);
        LOGGER.trace("Logout message encoded in base64 is [{}]", (Object)message);
        Map data = CollectionUtils.wrap((String)"SAMLResponse", (Object)message);
        String relayState = request.getParameter("RelayState");
        FunctionUtils.doIfNotNull((Object)relayState, value -> data.put("RelayState", value));
        return LogoutRedirectionResponse.builder().logoutPostUrl(Optional.ofNullable(location)).logoutPostData(data).build();
    }

    protected LogoutResponse buildSamlLogoutResponse(SamlRegisteredServiceMetadataAdaptor adaptor, SingleLogoutService sloService, SamlRegisteredService registeredService, LogoutRequest logoutRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = "_" + String.valueOf(RandomUtils.nextLong());
        Saml20ObjectBuilder builder = this.configurationContext.getLogoutResponseBuilder();
        Status status = builder.newStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "Success");
        Issuer issuer = builder.newIssuer(this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getCore().getEntityId());
        String location = StringUtils.isBlank((CharSequence)sloService.getResponseLocation()) ? sloService.getLocation() : sloService.getResponseLocation();
        LOGGER.trace("Creating logout response for binding [{}] with issuer [{}], location [{}] and service provider [{}]", new Object[]{sloService.getBinding(), issuer, location, adaptor.getEntityId()});
        LogoutResponse logoutResponse = builder.newLogoutResponse(id, location, issuer, status, logoutRequest.getID());
        if (this.signSamlLogoutResponseFor(registeredService)) {
            LOGGER.trace("Signing logout request for service provider [{}]", (Object)adaptor.getEntityId());
            LogoutResponse logoutResponseSigned = this.configurationContext.getSamlObjectSigner().encode(logoutResponse, registeredService, adaptor, response, request, sloService.getBinding(), (RequestAbstractType)logoutRequest, new MessageContext());
            this.configurationContext.getOpenSamlConfigBean().logObject((XMLObject)logoutResponseSigned);
            return logoutResponseSigned;
        }
        return logoutResponse;
    }

    protected Optional<LogoutRequest> getLogoutRequest(HttpServletRequest request) {
        String logoutRequest = WebUtils.getSingleLogoutRequest((HttpServletRequest)request);
        return Optional.ofNullable(logoutRequest).map(req -> {
            byte[] decodedRequest = EncodingUtils.decodeBase64((String)logoutRequest);
            return (LogoutRequest)SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), (byte[])decodedRequest, LogoutRequest.class);
        });
    }

    protected boolean signSamlLogoutResponseFor(SamlRegisteredService registeredService) {
        if (registeredService.getSignLogoutResponse().isUndefined()) {
            return this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getLogout().isSignLogoutResponse();
        }
        return registeredService.getSignLogoutResponse().isTrue();
    }

    @Generated
    public SamlIdPSingleLogoutRedirectionStrategy(SamlProfileHandlerConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }
}

