/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.validation;

import java.util.ArrayList;
import java.util.List;
import org.apereo.cas.client.authentication.ExactUrlPatternMatcherStrategy;
import org.apereo.cas.client.authentication.RegexUrlPatternMatcherStrategy;
import org.apereo.cas.client.authentication.UrlPatternMatcherStrategy;
import org.apereo.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyList {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<List<UrlPatternMatcherStrategy>> proxyChains;

    public ProxyList(Iterable<String[]> proxyChains) {
        CommonUtils.assertNotNull(proxyChains, "List of proxy chains cannot be null.");
        this.proxyChains = new ArrayList<List<UrlPatternMatcherStrategy>>();
        for (String[] list : proxyChains) {
            ArrayList<UrlPatternMatcherStrategy> chain = new ArrayList<UrlPatternMatcherStrategy>();
            for (String item : list) {
                if (item.startsWith("^")) {
                    chain.add(new RegexUrlPatternMatcherStrategy(item));
                    continue;
                }
                chain.add(new ExactUrlPatternMatcherStrategy(item));
            }
            this.proxyChains.add(chain);
        }
    }

    public ProxyList() {
        this(new ArrayList<String[]>());
    }

    public boolean contains(String[] proxiedList) {
        block0: for (List<UrlPatternMatcherStrategy> proxyChain : this.proxyChains) {
            StringBuilder loggingOutput = new StringBuilder();
            if (proxyChain.size() != proxiedList.length) continue;
            for (int linkIndex = 0; linkIndex < proxyChain.size(); ++linkIndex) {
                String linkToTest = proxiedList[linkIndex];
                loggingOutput.append(linkToTest);
                if (proxyChain.get(linkIndex).matches(linkToTest)) {
                    if (linkIndex == proxyChain.size() - 1) {
                        this.logger.info("Proxy chain matched: {}", (Object)loggingOutput.toString());
                        return true;
                    }
                } else {
                    this.logger.warn("Proxy chain did not match at {}. Skipping to next allowedProxyChain", (Object)loggingOutput.toString());
                    continue block0;
                }
                loggingOutput.append("->");
            }
        }
        this.logger.warn("No proxy chain matched the allowedProxyChains list.");
        return false;
    }

    public String toString() {
        return this.proxyChains.toString();
    }
}

