/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.configuration;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import org.apereo.cas.client.configuration.BaseConfigurationStrategy;
import org.apereo.cas.client.configuration.ConfigurationKey;
import org.apereo.cas.client.configuration.ConfigurationKeys;
import org.apereo.cas.client.util.CommonUtils;

public final class WebXmlConfigurationStrategyImpl
extends BaseConfigurationStrategy {
    private FilterConfig filterConfig;

    @Override
    public void init(FilterConfig filterConfig, Class<? extends Filter> clazz) {
        this.filterConfig = filterConfig;
    }

    @Override
    protected String get(ConfigurationKey configurationKey) {
        String value = this.filterConfig.getInitParameter(configurationKey.getName());
        if (CommonUtils.isNotBlank(value)) {
            CommonUtils.assertFalse(ConfigurationKeys.RENEW.equals(configurationKey), "Renew MUST be specified via context parameter or JNDI environment to avoid misconfiguration.");
            this.logger.info("Property [{}] loaded from FilterConfig.getInitParameter with value [{}]", (Object)configurationKey, (Object)value);
            return value;
        }
        String value2 = this.filterConfig.getServletContext().getInitParameter(configurationKey.getName());
        if (CommonUtils.isNotBlank(value2)) {
            this.logger.info("Property [{}] loaded from ServletContext.getInitParameter with value [{}]", (Object)configurationKey, (Object)value2);
            return value2;
        }
        return null;
    }
}

