/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.azure.ad.authentication.AzureActiveDirectoryAuthenticationHandler;
import org.apereo.cas.azure.ad.authentication.MicrosoftGraphPersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.azuread.AzureActiveDirectoryAuthenticationProperties;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication}, module="azuread")
@AutoConfiguration
public class CasAzureActiveDirectoryAuthenticationAutoConfiguration {

    @Configuration(value="AzureActiveDirectoryAuthenticationHandlerConfiguration", proxyBeanMethods=false)
    static class AzureActiveDirectoryAuthenticationHandlerConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.azure-active-directory.client-id").and("cas.authn.azure-active-directory.enabled").isTrue().evenIfMissing();

        AzureActiveDirectoryAuthenticationHandlerConfiguration() {
        }

        @ConditionalOnMissingBean(name={"microsoftAzureActiveDirectoryPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory microsoftAzureActiveDirectoryPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }

        @ConditionalOnMissingBean(name={"microsoftAzureActiveDirectoryAuthenticationHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationHandler microsoftAzureActiveDirectoryAuthenticationHandler(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="microsoftAzureActiveDirectoryPrincipalFactory") PrincipalFactory factory) {
            return (AuthenticationHandler)BeanSupplier.of(AuthenticationHandler.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                AzureActiveDirectoryAuthenticationProperties azure = casProperties.getAuthn().getAzureActiveDirectory();
                AzureActiveDirectoryAuthenticationHandler handler = new AzureActiveDirectoryAuthenticationHandler(servicesManager, factory, azure);
                handler.setState(azure.getState());
                handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)azure.getPrincipalTransformation()));
                handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)azure.getPasswordEncoder(), (ApplicationContext)applicationContext));
                handler.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)azure.getCredentialCriteria()));
                return handler;
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"microsoftAzureActiveDirectoryAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer microsoftAzureActiveDirectoryAuthenticationEventExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="microsoftAzureActiveDirectoryAuthenticationHandler") AuthenticationHandler handler, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
            return (AuthenticationEventExecutionPlanConfigurer)BeanSupplier.of(AuthenticationEventExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(handler, defaultPrincipalResolver)).otherwiseProxy().get();
        }
    }

    @Configuration(value="AzureActiveDirectoryAttributeConfiguration", proxyBeanMethods=false)
    static class AzureActiveDirectoryAttributeConfiguration {
        AzureActiveDirectoryAttributeConfiguration() {
        }

        @ConditionalOnMissingBean(name={"microsoftAzureActiveDirectoryAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public List<PersonAttributeDao> microsoftAzureActiveDirectoryAttributeRepositories(CasConfigurationProperties casProperties) {
            SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
            ArrayList<PersonAttributeDao> list = new ArrayList<PersonAttributeDao>();
            PrincipalAttributesProperties attrs = casProperties.getAuthn().getAttributeRepository();
            attrs.getAzureActiveDirectory().stream().filter(msft -> StringUtils.isNotBlank((CharSequence)msft.getClientId()) && StringUtils.isNotBlank((CharSequence)msft.getClientSecret())).forEach(msft -> {
                MicrosoftGraphPersonAttributeDao dao = new MicrosoftGraphPersonAttributeDao();
                FunctionUtils.doIfNotNull((Object)msft.getId(), id -> dao.setId(new String[]{id}));
                FunctionUtils.doIfNotNull((Object)msft.getApiBaseUrl(), dao::setApiBaseUrl);
                FunctionUtils.doIfNotNull((Object)msft.getGrantType(), dao::setGrantType);
                FunctionUtils.doIfNotNull((Object)msft.getLoginBaseUrl(), dao::setLoginBaseUrl);
                FunctionUtils.doIfNotNull((Object)msft.getLoggingLevel(), dao::setLoggingLevel);
                FunctionUtils.doIfNotNull((Object)msft.getAttributes(), dao::setProperties);
                FunctionUtils.doIfNotNull((Object)msft.getResource(), dao::setResource);
                FunctionUtils.doIfNotNull((Object)msft.getScope(), dao::setScope);
                dao.setTenant(resolver.resolve(msft.getTenant()));
                dao.setDomain(resolver.resolve(msft.getDomain()));
                dao.setClientSecret(resolver.resolve(msft.getClientSecret()));
                dao.setClientId(resolver.resolve(msft.getClientId()));
                dao.setOrder(msft.getOrder());
                list.add((PersonAttributeDao)dao);
            });
            return list;
        }

        @ConditionalOnMissingBean(name={"microsoftAzureActiveDirectoryAttributeRepositoryPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PersonDirectoryAttributeRepositoryPlanConfigurer microsoftAzureActiveDirectoryAttributeRepositoryPlanConfigurer(@Qualifier(value="microsoftAzureActiveDirectoryAttributeRepositories") List<PersonAttributeDao> repositories) {
            return plan -> repositories.stream().filter(PersonAttributeDao::isEnabled).forEach(arg_0 -> ((PersonDirectoryAttributeRepositoryPlan)plan).registerAttributeRepository(arg_0));
        }
    }
}

