/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.support.saml.services.BaseSamlRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataRequestedAttributesAttributeReleasePolicy
extends BaseSamlRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataRequestedAttributesAttributeReleasePolicy.class);
    private static final long serialVersionUID = -3483733307124962357L;
    private boolean useFriendlyName;

    @Override
    protected Map<String, List<Object>> getAttributesForSamlRegisteredService(Map<String, List<Object>> attributes, SamlRegisteredServiceCachingMetadataResolver resolver, SamlRegisteredServiceMetadataAdaptor facade, EntityDescriptor entityDescriptor, RegisteredServiceAttributeReleasePolicyContext context) {
        return this.fetchRequestedAttributes(attributes, context, facade);
    }

    protected List<String> determineRequestedAttributeDefinitions(RegisteredServiceAttributeReleasePolicyContext context) {
        String entityId = MetadataRequestedAttributesAttributeReleasePolicy.getEntityIdFromRequest(context);
        Optional<SamlRegisteredServiceMetadataAdaptor> facade = MetadataRequestedAttributesAttributeReleasePolicy.determineServiceProviderMetadataFacade(context, entityId);
        return facade.map(SamlRegisteredServiceMetadataAdaptor::getSsoDescriptor).map(sso -> sso.getAttributeConsumingServices().stream().map(svc -> svc.getRequestedAttributes().stream().map(attr -> this.useFriendlyName ? attr.getFriendlyName() : attr.getName()).collect(Collectors.toList())).flatMap(Collection::stream).sorted().distinct().collect(Collectors.toList())).orElseGet(ArrayList::new);
    }

    private Map<String, List<Object>> fetchRequestedAttributes(Map<String, List<Object>> attributes, RegisteredServiceAttributeReleasePolicyContext context, SamlRegisteredServiceMetadataAdaptor facade) {
        HashMap<String, List<Object>> releaseAttributes = new HashMap<String, List<Object>>();
        Optional.ofNullable(facade.getSsoDescriptor()).ifPresent(sso -> sso.getAttributeConsumingServices().forEach(svc -> svc.getRequestedAttributes().stream().filter(attr -> {
            String name = this.useFriendlyName ? attr.getFriendlyName() : attr.getName();
            LOGGER.debug("Checking for requested attribute [{}] in metadata for [{}]", (Object)name, (Object)context.getRegisteredService().getName());
            return attributes.containsKey(name);
        }).forEach(attr -> {
            String name = this.useFriendlyName ? attr.getFriendlyName() : attr.getName();
            LOGGER.debug("Found requested attribute [{}] in metadata for [{}]", (Object)name, (Object)context.getRegisteredService().getName());
            releaseAttributes.put(name, (List)attributes.get(name));
        })));
        return releaseAttributes;
    }

    @Generated
    public String toString() {
        return "MetadataRequestedAttributesAttributeReleasePolicy(super=" + super.toString() + ", useFriendlyName=" + this.useFriendlyName + ")";
    }

    @Generated
    public void setUseFriendlyName(boolean useFriendlyName) {
        this.useFriendlyName = useFriendlyName;
    }

    @Generated
    public boolean isUseFriendlyName() {
        return this.useFriendlyName;
    }

    @Generated
    public MetadataRequestedAttributesAttributeReleasePolicy(boolean useFriendlyName) {
        this.useFriendlyName = useFriendlyName;
    }

    @Generated
    public MetadataRequestedAttributesAttributeReleasePolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataRequestedAttributesAttributeReleasePolicy)) {
            return false;
        }
        MetadataRequestedAttributesAttributeReleasePolicy other = (MetadataRequestedAttributesAttributeReleasePolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.useFriendlyName == other.useFriendlyName;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetadataRequestedAttributesAttributeReleasePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.useFriendlyName ? 79 : 97);
        return result;
    }
}

