/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kafka.testkit.TestKitNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;

public class BrokerNode
implements TestKitNode {
    private final MetaPropertiesEnsemble initialMetaPropertiesEnsemble;
    private final boolean combined;
    private final Map<String, String> propertyOverrides;
    private final Set<String> logDataDirectories;

    public static Builder builder() {
        return new Builder();
    }

    private BrokerNode(MetaPropertiesEnsemble initialMetaPropertiesEnsemble, boolean combined, Map<String, String> propertyOverrides) {
        this.initialMetaPropertiesEnsemble = Objects.requireNonNull(initialMetaPropertiesEnsemble);
        this.combined = combined;
        this.propertyOverrides = Objects.requireNonNull(propertyOverrides);
        this.logDataDirectories = Collections.unmodifiableSet(initialMetaPropertiesEnsemble.logDirProps().keySet());
    }

    @Override
    public MetaPropertiesEnsemble initialMetaPropertiesEnsemble() {
        return this.initialMetaPropertiesEnsemble;
    }

    @Override
    public boolean combined() {
        return this.combined;
    }

    public Set<String> logDataDirectories() {
        return this.logDataDirectories;
    }

    public Map<String, String> propertyOverrides() {
        return this.propertyOverrides;
    }

    public static class Builder {
        private int id = -1;
        private String baseDirectory;
        private Uuid clusterId;
        private int numLogDirectories = 1;
        private Map<String, String> propertyOverrides = Collections.emptyMap();
        private boolean combined;

        private Builder() {
        }

        public int id() {
            return this.id;
        }

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setNumLogDirectories(int numLogDirectories) {
            this.numLogDirectories = numLogDirectories;
            return this;
        }

        public Builder setClusterId(Uuid clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder setBaseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        public Builder setCombined(boolean combined) {
            this.combined = combined;
            return this;
        }

        public Builder setPropertyOverrides(Map<String, String> propertyOverrides) {
            this.propertyOverrides = Collections.unmodifiableMap(new HashMap<String, String>(propertyOverrides));
            return this;
        }

        public BrokerNode build() {
            Objects.requireNonNull(this.baseDirectory);
            Objects.requireNonNull(this.clusterId);
            if (this.id == -1) {
                throw new IllegalArgumentException("You must set the node id.");
            }
            if (this.numLogDirectories < 1) {
                throw new IllegalArgumentException("The value of numLogDirectories should be at least 1.");
            }
            List logDataDirectories = IntStream.range(0, this.numLogDirectories).mapToObj(i -> {
                if (this.combined) {
                    return String.format("combined_%d_%d", this.id, i);
                }
                return String.format("broker_%d_data%d", this.id, i);
            }).map(logDir -> {
                if (Paths.get(logDir, new String[0]).isAbsolute()) {
                    return logDir;
                }
                return new File(this.baseDirectory, (String)logDir).getAbsolutePath();
            }).collect(Collectors.toList());
            MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
            copier.setMetaLogDir(Optional.of(logDataDirectories.get(0)));
            for (String logDir2 : logDataDirectories) {
                copier.setLogDirProps(logDir2, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(this.clusterId.toString()).setNodeId(this.id).setDirectoryId(copier.generateValidDirectoryId()).build());
            }
            return new BrokerNode(copier.copy(), this.combined, this.propertyOverrides);
        }
    }
}

