/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.gauth.GoogleAuthenticatorBypassEvaluator;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.GoogleAuthenticator})
@Configuration(value="GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration", proxyBeanMethods=false)
class GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration {
    GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration() {
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorBypassEvaluator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        Collection currentBypassEvaluators = applicationContext.getBeansWithAnnotation(GoogleAuthenticatorBypassEvaluator.class).values();
        currentBypassEvaluators.stream().filter(BeanSupplier::isNotProxy).map(MultifactorAuthenticationProviderBypassEvaluator.class::cast).filter(evaluator -> !evaluator.isEmpty()).map(evaluator -> evaluator.belongsToMultifactorAuthenticationProvider(gauth.getId())).filter(Optional::isPresent).map(Optional::get).sorted((Comparator<MultifactorAuthenticationProviderBypassEvaluator>)AnnotationAwareOrderComparator.INSTANCE).forEach(arg_0 -> ((DefaultChainingMultifactorAuthenticationBypassProvider)bypass).addMultifactorAuthenticationProviderBypassEvaluator(arg_0));
        return bypass;
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @GoogleAuthenticatorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        return new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(gauth.getId(), applicationContext);
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @GoogleAuthenticatorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(BeanCondition.on((String)"cas.authn.mfa.gauth.bypass.rest.url").given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new RestMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), applicationContext)).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @GoogleAuthenticatorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(BeanCondition.on((String)"cas.authn.mfa.gauth.bypass.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
            MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
            return new GroovyMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), applicationContext);
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @GoogleAuthenticatorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        boolean bypassActive = StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress());
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(bypassActive).supply(() -> new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), (ApplicationContext)applicationContext)).otherwiseProxy().get();
    }

    @Bean
    @GoogleAuthenticatorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())).supply(() -> new CredentialMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), applicationContext)).otherwiseProxy().get();
    }

    @Bean
    @GoogleAuthenticatorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        return new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(gauth.getId(), applicationContext);
    }

    @Bean
    @GoogleAuthenticatorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())).supply(() -> new PrincipalMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), (ApplicationContext)applicationContext)).otherwiseProxy().get();
    }

    @Bean
    @GoogleAuthenticatorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        boolean bypassActive = StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName());
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(bypassActive).supply(() -> new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), applicationContext)).otherwiseProxy().get();
    }
}

