/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.processor;

import java.util.Arrays;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.AttributeNames;
import org.thymeleaf.engine.HTMLAttributeName;
import org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring6.context.IThymeleafBindStatus;
import org.thymeleaf.spring6.util.FieldUtils;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;
import org.unbescape.html.HtmlEscape;

public final class SpringErrorClassTagProcessor
extends AbstractAttributeTagProcessor
implements IAttributeDefinitionsAware {
    public static final int ATTR_PRECEDENCE = 1800;
    public static final String ATTR_NAME = "errorclass";
    public static final String TARGET_ATTR_NAME = "class";
    private static final TemplateMode TEMPLATE_MODE = TemplateMode.HTML;
    private AttributeDefinition targetAttributeDefinition;

    public SpringErrorClassTagProcessor(String dialectPrefix) {
        super(TEMPLATE_MODE, dialectPrefix, null, false, ATTR_NAME, true, 1800, true);
    }

    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull((Object)attributeDefinitions, (String)"Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, TARGET_ATTR_NAME);
    }

    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        IEngineConfiguration configuration;
        IStandardExpressionParser expressionParser;
        IStandardExpression expression;
        Object expressionResult;
        Object newAttributeValue;
        IThymeleafBindStatus bindStatus = SpringErrorClassTagProcessor.computeBindStatus((IExpressionContext)context, tag);
        if (bindStatus == null) {
            HTMLAttributeName fieldAttributeName = AttributeNames.forHTMLName((String)attributeName.getPrefix(), (String)"field");
            throw new TemplateProcessingException("Cannot apply \"" + attributeName + "\": this attribute requires the existence of a \"name\" (or " + Arrays.asList(fieldAttributeName.getCompleteAttributeNames()) + ") attribute with non-empty value in the same host tag.");
        }
        if (bindStatus.isError() && (newAttributeValue = HtmlEscape.escapeHtml4Xml((String)((expressionResult = (expression = (expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)(configuration = context.getConfiguration()))).parseExpression((IExpressionContext)context, attributeValue)).execute((IExpressionContext)context)) == null ? null : expressionResult.toString()))) != null && ((String)newAttributeValue).length() > 0) {
            String currentValue;
            AttributeName targetAttributeName = this.targetAttributeDefinition.getAttributeName();
            if (tag.hasAttribute(targetAttributeName) && (currentValue = tag.getAttributeValue(targetAttributeName)).length() > 0) {
                newAttributeValue = currentValue + " " + (String)newAttributeValue;
            }
            StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.targetAttributeDefinition, (String)TARGET_ATTR_NAME, (String)newAttributeValue);
        }
    }

    private static IThymeleafBindStatus computeBindStatus(IExpressionContext context, IProcessableElementTag tag) {
        IThymeleafBindStatus bindStatus = (IThymeleafBindStatus)context.getVariable("thymeleafFieldBindStatus");
        if (bindStatus != null) {
            return bindStatus;
        }
        String fieldName = tag.getAttributeValue("name");
        if (StringUtils.isEmptyOrWhitespace((String)fieldName)) {
            return null;
        }
        VariableExpression boundExpression = (VariableExpression)context.getVariable("springBoundObjectExpression");
        if (boundExpression == null) {
            return FieldUtils.getBindStatusFromParsedExpression(context, false, fieldName);
        }
        String boundExpressionStr = boundExpression.getExpression();
        String computedFieldName = boundExpressionStr.indexOf(46) == -1 ? boundExpressionStr + "." + fieldName : boundExpressionStr.substring(0, boundExpressionStr.indexOf(46)) + "." + fieldName;
        return FieldUtils.getBindStatusFromParsedExpression(context, false, computedFieldName);
    }
}

