/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.consent.ConsentCoreProperties;
import org.apereo.cas.consent.CasConsentableAttribute;
import org.apereo.cas.consent.ConsentDecision;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.consent.ConsentReminderOptions;
import org.apereo.cas.consent.ConsentableAttributeBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractConsentAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConsentAction.class);
    protected final CasConfigurationProperties casProperties;
    protected final ServicesManager servicesManager;
    protected final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    protected final ConsentEngine consentEngine;
    protected final AttributeDefinitionStore attributeDefinitionStore;

    protected RegisteredService getRegisteredServiceForConsent(RequestContext requestContext, Service service) {
        return (RegisteredService)FunctionUtils.doUnchecked(() -> {
            Service serviceToUse = this.authenticationRequestServiceSelectionStrategies.resolveService(service);
            RegisteredService registeredService = this.servicesManager.findServiceBy(serviceToUse);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            return registeredService;
        });
    }

    protected void prepareConsentForRequestContext(RequestContext requestContext) throws Throwable {
        ConsentCoreProperties consentProperties = this.casProperties.getConsent().getCore();
        WebApplicationService originalService = WebUtils.getService((RequestContext)requestContext);
        Service service = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)originalService);
        RegisteredService registeredService = this.getRegisteredServiceForConsent(requestContext, service);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Map attributes = this.consentEngine.resolveConsentableAttributesFrom(authentication, service, registeredService);
        MutableAttributeMap flowScope = requestContext.getFlowScope();
        this.prepareConsentableAttributes(attributes, requestContext);
        WebUtils.putPrincipal((RequestContext)requestContext, (Principal)authentication.getPrincipal());
        WebUtils.putServiceIntoFlashScope((RequestContext)requestContext, (Service)service);
        ConsentDecision decision = this.consentEngine.findConsentDecision(service, registeredService, authentication);
        flowScope.put("option", (Object)Optional.ofNullable(decision).map(consentDecision -> consentDecision.getOptions().getValue()).orElseGet(() -> ((ConsentReminderOptions)ConsentReminderOptions.ATTRIBUTE_NAME).getValue()));
        long reminder = decision == null ? consentProperties.getReminder() : decision.getReminder().longValue();
        flowScope.put("reminder", (Object)reminder);
        flowScope.put("reminderTimeUnit", (Object)Optional.ofNullable(decision).map(consentDecision -> consentDecision.getReminderTimeUnit().name()).orElseGet(() -> consentProperties.getReminderTimeUnit().name()));
    }

    protected void prepareConsentableAttributes(Map<String, List<Object>> attributes, RequestContext context) {
        ApplicationContext applicationContext = context.getActiveFlow().getApplicationContext();
        List builders = applicationContext.getBeansOfType(ConsentableAttributeBuilder.class).values().stream().filter(BeanSupplier::isNotProxy).collect(Collectors.toList());
        AnnotationAwareOrderComparator.sortIfNecessary(builders);
        ArrayList consentableAttributes = new ArrayList();
        LOGGER.debug("Preparing consentable attributes [{}]", attributes);
        attributes.forEach((key, value) -> {
            CasConsentableAttribute attr = CasConsentableAttribute.builder().name(key).values(value).build();
            for (ConsentableAttributeBuilder builder : builders) {
                LOGGER.trace("Preparing to build consentable attribute [{}] via [{}]", (Object)attr, (Object)builder.getName());
                attr = builder.build(attr);
                LOGGER.trace("Finalized consentable attribute [{}]", (Object)attr);
            }
            consentableAttributes.add(attr);
        });
        context.getFlowScope().put("attributes", consentableAttributes);
    }

    @Generated
    protected AbstractConsentAction(CasConfigurationProperties casProperties, ServicesManager servicesManager, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, ConsentEngine consentEngine, AttributeDefinitionStore attributeDefinitionStore) {
        this.casProperties = casProperties;
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.consentEngine = consentEngine;
        this.attributeDefinitionStore = attributeDefinitionStore;
    }
}

