/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.remote;

import java.util.HashMap;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.AbstractConnectorFacade;
import org.identityconnectors.framework.impl.api.LoggingProxy;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteOperationInvocationHandler;

public class RemoteConnectorFacadeImpl
extends AbstractConnectorFacade {
    final String remoteConnectorFacadeKey;

    private static String generateRemoteConnectorFacadeKey(APIConfigurationImpl configuration) {
        APIConfigurationImpl copy = new APIConfigurationImpl(configuration);
        copy.setProducerBufferSize(0);
        copy.setTimeoutMap(new HashMap<Class<? extends APIOperation>, Integer>());
        return SerializerUtil.serializeBase64Object((Object)copy);
    }

    public RemoteConnectorFacadeImpl(APIConfigurationImpl configuration) {
        super(RemoteConnectorFacadeImpl.generateRemoteConnectorFacadeKey(configuration), configuration.getConnectorInfo());
        this.getAPIConfiguration().setProducerBufferSize(configuration.getProducerBufferSize());
        this.getAPIConfiguration().setTimeoutMap(configuration.getTimeoutMap());
        this.remoteConnectorFacadeKey = this.getConnectorFacadeKey();
    }

    public RemoteConnectorFacadeImpl(RemoteConnectorInfoImpl connectorInfo, String configuration) {
        super(configuration, connectorInfo);
        this.remoteConnectorFacadeKey = RemoteConnectorFacadeImpl.generateRemoteConnectorFacadeKey(this.getAPIConfiguration());
    }

    @Override
    protected APIOperation getOperationImplementation(Class<? extends APIOperation> api) {
        RemoteOperationInvocationHandler handler = new RemoteOperationInvocationHandler((RemoteConnectorInfoImpl)this.getAPIConfiguration().getConnectorInfo(), this.remoteConnectorFacadeKey, api);
        APIOperation proxy = this.newAPIOperationProxy(api, handler);
        proxy = this.createTimeoutProxy(api, proxy);
        if (LoggingProxy.isLoggable()) {
            proxy = this.createLoggingProxy(api, proxy);
        }
        return proxy;
    }

    public void dispose() {
    }
}

