/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.AddResponse;
import org.ldaptive.AttributeModification;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.DeleteResponse;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.ModifyResponse;
import org.ldaptive.ResultCode;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.ad.UnicodePwdAttribute;
import org.ldaptive.control.util.PagedResultsClient;
import org.ldaptive.extended.ExtendedOperation;
import org.ldaptive.extended.ExtendedRequest;
import org.ldaptive.extended.ExtendedResponse;
import org.ldaptive.extended.PasswordModifyRequest;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.referral.FollowSearchReferralHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LoggingEventBuilder;

public class LdapConnectionFactory
implements Closeable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapConnectionFactory.class);
    private final ConnectionFactory connectionFactory;

    public boolean executeAddOperation(LdapEntry entry) {
        return (Boolean)FunctionUtils.doAndHandle(() -> {
            AddOperation operation = new AddOperation(this.connectionFactory);
            AddResponse response = operation.execute(new AddRequest(entry.getDn(), entry.getAttributes()));
            LOGGER.debug("Result code [{}], message: [{}]", (Object)response.getResultCode(), (Object)response.getDiagnosticMessage());
            return response.getResultCode() == ResultCode.SUCCESS;
        }, e -> false).get();
    }

    public boolean executeDeleteOperation(LdapEntry entry) {
        return (Boolean)FunctionUtils.doAndHandle(() -> {
            DeleteOperation delete = new DeleteOperation(this.connectionFactory);
            DeleteRequest request = new DeleteRequest(entry.getDn());
            DeleteResponse response = delete.execute(request);
            LOGGER.debug("Result code [{}], message: [{}]", (Object)response.getResultCode(), (Object)response.getDiagnosticMessage());
            return response.getResultCode() == ResultCode.SUCCESS;
        }, e -> false).get();
    }

    public boolean executeModifyOperation(String currentDn, Map<String, ? extends Set<String>> attributes) {
        return (Boolean)FunctionUtils.doAndHandle(() -> {
            ModifyOperation operation = new ModifyOperation(this.connectionFactory);
            AttributeModification[] mods = (AttributeModification[])attributes.entrySet().stream().map(entry -> {
                String[] values = ((Set)entry.getValue()).toArray(ArrayUtils.EMPTY_STRING_ARRAY);
                LdapAttribute attr = new LdapAttribute((String)entry.getKey(), values);
                LOGGER.debug("Constructed new attribute [{}]", (Object)attr);
                return new AttributeModification(AttributeModification.Type.REPLACE, attr);
            }).toArray(AttributeModification[]::new);
            ModifyRequest request = new ModifyRequest(currentDn, mods);
            ModifyResponse response = operation.execute(request);
            LOGGER.debug("Result code [{}], message: [{}]", (Object)response.getResultCode(), (Object)response.getDiagnosticMessage());
            return response.getResultCode() == ResultCode.SUCCESS;
        }, e -> false).get();
    }

    public boolean executeModifyOperation(String currentDn, LdapEntry entry) {
        Map<String, HashSet> attributes = entry.getAttributes().stream().collect(Collectors.toMap(LdapAttribute::getName, ldapAttribute -> new HashSet(ldapAttribute.getStringValues())));
        return this.executeModifyOperation(currentDn, attributes);
    }

    public SearchResponse executeSearchOperation(String baseDn, FilterTemplate filter, int pageSize, String ... returnAttributes) throws LdapException {
        return this.executeSearchOperation(baseDn, filter, pageSize, (String[])null, returnAttributes);
    }

    public SearchResponse executeSearchOperation(String baseDn, FilterTemplate filter, int pageSize, String[] binaryAttributes, String[] returnAttributes) throws LdapException {
        SearchRequest request = LdapUtils.newLdaptiveSearchRequest(baseDn, filter, binaryAttributes, returnAttributes);
        if (pageSize <= 0) {
            SearchOperation searchOperation = new SearchOperation(this.connectionFactory);
            searchOperation.setSearchResultHandlers(new SearchResultHandler[]{new FollowSearchReferralHandler()});
            return searchOperation.execute(request);
        }
        PagedResultsClient client = new PagedResultsClient(this.connectionFactory, pageSize);
        return client.executeToCompletion(request);
    }

    public SearchResponse executeSearchOperation(String baseDn, FilterTemplate filter, int pageSize) throws LdapException {
        return this.executeSearchOperation(baseDn, filter, pageSize, ReturnAttributes.ALL_USER.value(), ReturnAttributes.ALL_USER.value());
    }

    public boolean executePasswordModifyOperation(String currentDn, char[] oldPassword, char[] newPassword, AbstractLdapProperties.LdapType type) {
        try {
            boolean secureLdap;
            boolean oldPasswordAvailable = oldPassword != null && oldPassword.length > 0;
            ConnectionConfig connConfig = this.connectionFactory.getConnectionConfig();
            boolean bl = secureLdap = connConfig.getLdapUrl() != null && !connConfig.getLdapUrl().toLowerCase(Locale.ENGLISH).contains("ldaps://");
            if (connConfig.getUseStartTLS() || secureLdap) {
                LOGGER.warn("Executing password modification op under a non-secure LDAP connection; To modify password attributes, the connection to the LDAP server {} be secured and/or encrypted.", (Object)(type == AbstractLdapProperties.LdapType.AD ? "MUST" : "SHOULD"));
            }
            if (type == AbstractLdapProperties.LdapType.AD) {
                LOGGER.debug("Executing password change op for active directory based on [https://support.microsoft.com/en-us/kb/269190]change type: [{}]", (Object)(oldPasswordAvailable ? "change" : "reset"));
                ModifyOperation operation = new ModifyOperation(this.connectionFactory);
                ModifyResponse response = oldPasswordAvailable ? operation.execute(new ModifyRequest(currentDn, new AttributeModification[]{new AttributeModification(AttributeModification.Type.DELETE, (LdapAttribute)new UnicodePwdAttribute(new String[]{new String(oldPassword)})), new AttributeModification(AttributeModification.Type.ADD, (LdapAttribute)new UnicodePwdAttribute(new String[]{new String(newPassword)}))})) : operation.execute(new ModifyRequest(currentDn, new AttributeModification[]{new AttributeModification(AttributeModification.Type.REPLACE, (LdapAttribute)new UnicodePwdAttribute(new String[]{new String(newPassword)}))}));
                boolean success = response.getResultCode() == ResultCode.SUCCESS;
                LoggingEventBuilder logLevel = success ? LOGGER.atDebug() : LOGGER.atError();
                logLevel.log("Result code [{}], message: [{}]", (Object)response.getResultCode(), (Object)response.getDiagnosticMessage());
                return success;
            }
            LOGGER.debug("Executing password modification op for generic LDAP");
            ExtendedOperation operation = new ExtendedOperation(this.connectionFactory);
            ExtendedResponse response = operation.execute((ExtendedRequest)new PasswordModifyRequest(currentDn, oldPasswordAvailable ? new String(oldPassword) : null, new String(newPassword)));
            LOGGER.debug("Result code [{}], message: [{}]", (Object)response.getResultCode(), (Object)response.getDiagnosticMessage());
            return response.getResultCode() == ResultCode.SUCCESS;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }

    @Override
    public void close() {
        this.connectionFactory.close();
    }

    @Generated
    public LdapConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Generated
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

