/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.layoutdialect.decorators.xml;

import nz.net.ultraq.thymeleaf.layoutdialect.decorators.Decorator;
import nz.net.ultraq.thymeleaf.layoutdialect.models.AttributeMerger;
import nz.net.ultraq.thymeleaf.layoutdialect.models.extensions.IModelExtensions;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IDocType;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;

public class XmlDocumentDecorator
implements Decorator {
    protected final ITemplateContext context;

    private static IModel rootModelFinder(IModel iModel) {
        return IModelExtensions.findModel(iModel, iTemplateEvent -> iTemplateEvent instanceof IProcessableElementTag);
    }

    private static boolean documentContainsDocType(IModel iModel) {
        int n = iModel.size();
        for (int i = 0; i < n; ++i) {
            ITemplateEvent iTemplateEvent = iModel.get(i);
            if (iTemplateEvent instanceof IDocType) {
                return true;
            }
            if (iTemplateEvent instanceof IOpenElementTag) break;
        }
        return false;
    }

    public XmlDocumentDecorator(ITemplateContext iTemplateContext) {
        this.context = iTemplateContext;
    }

    @Override
    public IModel decorate(IModel iModel, IModel iModel2) {
        ITemplateEvent iTemplateEvent;
        int n;
        IModelFactory iModelFactory = this.context.getModelFactory();
        IModel iModel3 = new AttributeMerger(this.context).merge(XmlDocumentDecorator.rootModelFinder(iModel), XmlDocumentDecorator.rootModelFinder(iModel2));
        int n2 = iModel.size();
        for (n = 0; n < n2; ++n) {
            iTemplateEvent = iModel.get(n);
            if (iTemplateEvent instanceof IDocType) {
                if (XmlDocumentDecorator.documentContainsDocType(iModel2)) continue;
                IModelExtensions.insertWithWhitespace(iModel3, 0, iTemplateEvent, iModelFactory);
                continue;
            }
            if (iTemplateEvent instanceof IComment) {
                IModelExtensions.insertWithWhitespace(iModel3, 0, iTemplateEvent, iModelFactory);
                continue;
            }
            if (iTemplateEvent instanceof IOpenElementTag) break;
        }
        for (n = n2 - 1; n >= 0; --n) {
            iTemplateEvent = iModel.get(n);
            if (iTemplateEvent instanceof IComment) {
                IModelExtensions.insertWithWhitespace(iModel3, iModel3.size(), iTemplateEvent, iModelFactory);
                continue;
            }
            if (iTemplateEvent instanceof ICloseElementTag) break;
        }
        return iModel3;
    }

    public final ITemplateContext getContext() {
        return this.context;
    }
}

