/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.support;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.flowable.support.DropdownFormType;
import org.apache.syncope.core.flowable.support.PasswordFormType;
import org.flowable.bpmn.model.FormProperty;
import org.flowable.bpmn.model.FormValue;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.engine.form.AbstractFormType;
import org.flowable.engine.impl.form.DefaultTaskFormHandler;
import org.flowable.engine.impl.form.FormPropertyHandler;
import org.flowable.engine.impl.form.FormTypes;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeTaskFormHandler
extends DefaultTaskFormHandler {
    private static final long serialVersionUID = -5271243544388455797L;
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeTaskFormHandler.class);

    protected static Optional<AbstractFormType> parseFormPropertyType(FormProperty formProperty, ExpressionManager expressionManager) {
        Object formType = null;
        switch (formProperty.getType()) {
            case "dropdown": {
                if (formProperty.getFormValues().isEmpty() || !"dropdownValueProvider".equals(((FormValue)formProperty.getFormValues().getFirst()).getId())) {
                    LOG.warn("A single value with id 'dropdownValueProvider' was expected, ignoring");
                    break;
                }
                formType = new DropdownFormType(((FormValue)formProperty.getFormValues().getFirst()).getName());
                break;
            }
            case "password": {
                formType = new PasswordFormType();
                break;
            }
        }
        return Optional.ofNullable(formType);
    }

    public void parseConfiguration(List<FormProperty> formProperties, String formKey, DeploymentEntity deployment, ProcessDefinition processDefinition) {
        this.deploymentId = deployment.getId();
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager();
        if (StringUtils.isNotEmpty((CharSequence)formKey)) {
            this.formKey = expressionManager.createExpression(formKey);
        }
        FormTypes formTypes = CommandContextUtil.getProcessEngineConfiguration().getFormTypes();
        formProperties.forEach(formProperty -> {
            FormPropertyHandler formPropertyHandler = new FormPropertyHandler();
            formPropertyHandler.setId(formProperty.getId());
            formPropertyHandler.setName(formProperty.getName());
            AbstractFormType type = SyncopeTaskFormHandler.parseFormPropertyType(formProperty, expressionManager).orElseGet(() -> formTypes.parseFormPropertyType(formProperty));
            formPropertyHandler.setType(type);
            formPropertyHandler.setRequired(formProperty.isRequired());
            formPropertyHandler.setReadable(formProperty.isReadable());
            formPropertyHandler.setWritable(formProperty.isWriteable());
            formPropertyHandler.setVariableName(formProperty.getVariable());
            if (StringUtils.isNotEmpty((CharSequence)formProperty.getExpression())) {
                Expression expression = expressionManager.createExpression(formProperty.getExpression());
                formPropertyHandler.setVariableExpression(expression);
            }
            if (StringUtils.isNotEmpty((CharSequence)formProperty.getDefaultExpression())) {
                Expression defaultExpression = expressionManager.createExpression(formProperty.getDefaultExpression());
                formPropertyHandler.setDefaultExpression(defaultExpression);
            }
            this.formPropertyHandlers.add(formPropertyHandler);
        });
    }
}

