/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.RealmMember;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.to.RelatableTO;
import org.apache.syncope.common.lib.to.RelationshipTO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="_class")
@JsonPropertyOrder(value={"_class"})
@Schema(subTypes={UserCR.class, GroupCR.class, AnyObjectCR.class}, discriminatorProperty="_class")
public abstract class AnyCR
implements BaseBean,
RealmMember,
RelatableTO {
    private static final long serialVersionUID = -1180587903919947455L;
    @JacksonXmlProperty(localName="_class", isAttribute=true)
    @JsonProperty(value="_class")
    private String discriminator;
    private String realm;
    private final Set<String> auxClasses = new HashSet<String>();
    private final Set<Attr> plainAttrs = new HashSet<Attr>();
    private final Set<String> resources = new HashSet<String>();
    private final List<RelationshipTO> relationships = new ArrayList<RelationshipTO>();

    @Schema(name="_class", requiredMode=Schema.RequiredMode.REQUIRED)
    public abstract String getDiscriminator();

    public void setDiscriminator(String discriminator) {
    }

    @Override
    @JsonProperty(required=true)
    public String getRealm() {
        return this.realm;
    }

    @Override
    public void setRealm(String realm) {
        this.realm = realm;
    }

    @Override
    public Set<String> getAuxClasses() {
        return this.auxClasses;
    }

    @Override
    @JsonIgnore
    public Optional<Attr> getPlainAttr(String schema) {
        return this.plainAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    @JacksonXmlElementWrapper(localName="plainAttrs")
    @JacksonXmlProperty(localName="plainAttr")
    public Set<Attr> getPlainAttrs() {
        return this.plainAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<Attr> getDerAttr(String schema) {
        return Optional.empty();
    }

    @Override
    @JsonIgnore
    public Set<Attr> getDerAttrs() {
        return Set.of();
    }

    @Override
    @JacksonXmlElementWrapper(localName="resources")
    @JacksonXmlProperty(localName="resource")
    public Set<String> getResources() {
        return this.resources;
    }

    @Override
    @JsonIgnore
    public Optional<RelationshipTO> getRelationship(String type, String otherKey) {
        return this.relationships.stream().filter(relationship -> type.equals(relationship.getType()) && otherKey.equals(relationship.getOtherEndKey())).findFirst();
    }

    @Override
    @JacksonXmlElementWrapper(localName="relationships")
    @JacksonXmlProperty(localName="relationship")
    public List<RelationshipTO> getRelationships() {
        return this.relationships;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.discriminator).append((Object)this.realm).append(this.auxClasses).append(this.plainAttrs).append(this.resources).append(this.relationships).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyCR other = (AnyCR)obj;
        return new EqualsBuilder().append((Object)this.discriminator, (Object)other.discriminator).append((Object)this.realm, (Object)other.realm).append(this.auxClasses, other.auxClasses).append(this.plainAttrs, other.plainAttrs).append(this.resources, other.resources).append(this.relationships, other.relationships).build();
    }

    protected static abstract class Builder<R extends AnyCR, B extends Builder<R, B>> {
        protected R instance;

        Builder(String realm) {
            ((AnyCR)this.getInstance()).setRealm(realm);
        }

        protected abstract R newInstance();

        protected final R getInstance() {
            if (this.instance == null) {
                this.instance = this.newInstance();
            }
            return this.instance;
        }

        public B auxClass(String auxClass) {
            ((AnyCR)this.getInstance()).getAuxClasses().add(auxClass);
            return (B)this;
        }

        public B auxClasses(String ... auxClasses) {
            ((AnyCR)this.getInstance()).getAuxClasses().addAll(List.of(auxClasses));
            return (B)this;
        }

        public B auxClasses(Collection<String> auxClasses) {
            ((AnyCR)this.getInstance()).getAuxClasses().addAll(auxClasses);
            return (B)this;
        }

        public B plainAttr(Attr plainAttr) {
            ((AnyCR)this.getInstance()).getPlainAttrs().add(plainAttr);
            return (B)this;
        }

        public B plainAttrs(Attr ... plainAttrs) {
            ((AnyCR)this.getInstance()).getPlainAttrs().addAll(List.of(plainAttrs));
            return (B)this;
        }

        public B plainAttrs(Collection<Attr> plainAttrs) {
            ((AnyCR)this.getInstance()).getPlainAttrs().addAll(plainAttrs);
            return (B)this;
        }

        public B resource(String resource) {
            ((AnyCR)this.getInstance()).getResources().add(resource);
            return (B)this;
        }

        public B resources(String ... resources) {
            ((AnyCR)this.getInstance()).getResources().addAll(List.of(resources));
            return (B)this;
        }

        public B resources(Collection<String> resources) {
            ((AnyCR)this.getInstance()).getResources().addAll(resources);
            return (B)this;
        }

        public B relationship(RelationshipTO relationship) {
            ((AnyCR)this.getInstance()).getRelationships().add(relationship);
            return (B)this;
        }

        public B relationships(RelationshipTO ... relationships) {
            ((AnyCR)this.getInstance()).getRelationships().addAll(List.of(relationships));
            return (B)this;
        }

        public B relationships(Collection<RelationshipTO> relationships) {
            ((AnyCR)this.getInstance()).getRelationships().addAll(relationships);
            return (B)this;
        }

        public R build() {
            return this.getInstance();
        }
    }
}

