/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.config;

import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.config.PropertiesSource;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalPropertiesSource
implements PropertiesSource {
    private static final Logger log = LoggerFactory.getLogger(OptionalPropertiesSource.class);
    private final PropertiesSource propertiesSource;

    public OptionalPropertiesSource(PropertiesSource source) {
        Assert.notNull((Object)source, (String)"source cannot be null.");
        this.propertiesSource = source;
    }

    @Override
    public Map<String, String> getProperties() {
        try {
            return this.propertiesSource.getProperties();
        }
        catch (Exception e) {
            log.debug("Unable to obtain properties from optional properties source {}", (Object)this.propertiesSource);
            return new LinkedHashMap<String, String>();
        }
    }
}

