/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.anyobject;

import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.ARelationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.common.validation.AnyObjectCheck;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAny;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGroupableRelatable;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyType;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTypeClass;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAMembership;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAARelationship;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JSONAnyObjectListener;

@Entity
@Table(name="AnyObject", uniqueConstraints={@UniqueConstraint(columnNames={"name", "type_id"})})
@EntityListeners(value={JSONAnyObjectListener.class})
@Cacheable
@AnyObjectCheck
public class JPAAnyObject
extends AbstractGroupableRelatable<AnyObject, AMembership, ARelationship>
implements AnyObject {
    private static final long serialVersionUID = 9063766472970643492L;
    public static final String TABLE = "AnyObject";
    @Size(min=1)
    private @Size(min=1) String name;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private JPAAnyType type;
    private String plainAttrs;
    @Transient
    private final List<PlainAttr> plainAttrsList = new ArrayList<PlainAttr>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="anyObject_id")}, inverseJoinColumns={@JoinColumn(name="resource_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"anyObject_id", "resource_id"})})
    private List<JPAExternalResource> resources = new ArrayList<JPAExternalResource>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(joinColumns={@JoinColumn(name="anyObject_id")}, inverseJoinColumns={@JoinColumn(name="anyTypeClass_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"anyObject_id", "anyTypeClass_id"})})
    private List<JPAAnyTypeClass> auxClasses = new ArrayList<JPAAnyTypeClass>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="leftEnd")
    @Valid
    private List<JPAARelationship> relationships = new ArrayList<JPAARelationship>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="leftEnd")
    @Valid
    private List<JPAAMembership> memberships = new ArrayList<JPAAMembership>();
    private static int pcInheritedFieldCount = AbstractGroupableRelatable.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getName() {
        return JPAAnyObject.pcGetname(this);
    }

    public void setName(String name) {
        JPAAnyObject.pcSetname(this, name);
    }

    public AnyType getType() {
        return JPAAnyObject.pcGettype(this);
    }

    public void setType(AnyType type) {
        this.checkType(type, JPAAnyType.class);
        JPAAnyObject.pcSettype(this, (JPAAnyType)type);
    }

    public boolean add(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        return JPAAnyObject.pcGetresources(this).contains((JPAExternalResource)resource) || JPAAnyObject.pcGetresources(this).add((JPAExternalResource)resource);
    }

    public List<? extends ExternalResource> getResources() {
        return JPAAnyObject.pcGetresources(this);
    }

    @Override
    public List<PlainAttr> getPlainAttrsList() {
        return this.plainAttrsList;
    }

    @Override
    public String getPlainAttrsJSON() {
        return JPAAnyObject.pcGetplainAttrs(this);
    }

    @Override
    public void setPlainAttrsJSON(String plainAttrs) {
        JPAAnyObject.pcSetplainAttrs(this, plainAttrs);
    }

    public boolean add(PlainAttr attr) {
        return this.plainAttrsList.add(attr);
    }

    public boolean remove(PlainAttr attr) {
        return this.plainAttrsList.removeIf(a -> a.getSchema().equals(attr.getSchema()) && Objects.equals(a.getMembership(), attr.getMembership()));
    }

    public boolean add(AnyTypeClass auxClass) {
        this.checkType(auxClass, JPAAnyTypeClass.class);
        return JPAAnyObject.pcGetauxClasses(this).contains((JPAAnyTypeClass)auxClass) || JPAAnyObject.pcGetauxClasses(this).add((JPAAnyTypeClass)auxClass);
    }

    public List<? extends AnyTypeClass> getAuxClasses() {
        return JPAAnyObject.pcGetauxClasses(this);
    }

    public boolean add(ARelationship relationship) {
        this.checkType(relationship, JPAARelationship.class);
        return JPAAnyObject.pcGetrelationships(this).add((JPAARelationship)relationship);
    }

    public List<? extends ARelationship> getRelationships() {
        return JPAAnyObject.pcGetrelationships(this);
    }

    public boolean add(AMembership membership) {
        this.checkType(membership, JPAAMembership.class);
        return JPAAnyObject.pcGetmemberships(this).add((JPAAMembership)membership);
    }

    public boolean remove(AMembership membership) {
        this.checkType(membership, JPAAMembership.class);
        this.plainAttrsList.removeIf(attr -> Objects.equals(attr.getMembership(), membership.getKey()));
        return JPAAnyObject.pcGetmemberships(this).remove((JPAAMembership)membership);
    }

    public List<? extends AMembership> getMemberships() {
        return JPAAnyObject.pcGetmemberships(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = AbstractAny.class;
        pcFieldNames = new String[]{"auxClasses", "memberships", "name", "plainAttrs", "relationships", "resources", "type"};
        pcFieldTypes = new Class[]{List.class, List.class, String.class, String.class, List.class, List.class, JPAAnyType.class};
        pcFieldFlags = new byte[]{5, 5, 26, 26, 5, 10, 26};
        PCRegistry.register(JPAAnyObject.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAAnyObject", (PersistenceCapable)new JPAAnyObject());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.auxClasses = null;
        this.memberships = null;
        this.name = null;
        this.plainAttrs = null;
        this.relationships = null;
        this.resources = null;
        this.type = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAAnyObject jPAAnyObject = new JPAAnyObject();
        if (bl) {
            jPAAnyObject.pcClearFields();
        }
        jPAAnyObject.pcStateManager = stateManager;
        jPAAnyObject.pcCopyKeyFieldsFromObjectId(object);
        return jPAAnyObject;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAAnyObject jPAAnyObject = new JPAAnyObject();
        if (bl) {
            jPAAnyObject.pcClearFields();
        }
        jPAAnyObject.pcStateManager = stateManager;
        return jPAAnyObject;
    }

    protected static int pcGetManagedFieldCount() {
        return 7 + AbstractAny.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.auxClasses = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.memberships = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.plainAttrs = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.relationships = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.resources = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.type = (JPAAnyType)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.auxClasses);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.memberships);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.plainAttrs);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.relationships);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAAnyObject jPAAnyObject, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAAnyObject, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.auxClasses = jPAAnyObject.auxClasses;
                return;
            }
            case 1: {
                this.memberships = jPAAnyObject.memberships;
                return;
            }
            case 2: {
                this.name = jPAAnyObject.name;
                return;
            }
            case 3: {
                this.plainAttrs = jPAAnyObject.plainAttrs;
                return;
            }
            case 4: {
                this.relationships = jPAAnyObject.relationships;
                return;
            }
            case 5: {
                this.resources = jPAAnyObject.resources;
                return;
            }
            case 6: {
                this.type = jPAAnyObject.type;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAAnyObject jPAAnyObject = (JPAAnyObject)object;
        if (jPAAnyObject.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAAnyObject, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAAnyObject.class;
    }

    private static final List pcGetauxClasses(JPAAnyObject jPAAnyObject) {
        if (jPAAnyObject.pcStateManager == null) {
            return jPAAnyObject.auxClasses;
        }
        int n = pcInheritedFieldCount + 0;
        jPAAnyObject.pcStateManager.accessingField(n);
        return jPAAnyObject.auxClasses;
    }

    private static final void pcSetauxClasses(JPAAnyObject jPAAnyObject, List list) {
        if (jPAAnyObject.pcStateManager == null) {
            jPAAnyObject.auxClasses = list;
            return;
        }
        jPAAnyObject.pcStateManager.settingObjectField((PersistenceCapable)jPAAnyObject, pcInheritedFieldCount + 0, jPAAnyObject.auxClasses, (Object)list, 0);
    }

    private static final List pcGetmemberships(JPAAnyObject jPAAnyObject) {
        if (jPAAnyObject.pcStateManager == null) {
            return jPAAnyObject.memberships;
        }
        int n = pcInheritedFieldCount + 1;
        jPAAnyObject.pcStateManager.accessingField(n);
        return jPAAnyObject.memberships;
    }

    private static final void pcSetmemberships(JPAAnyObject jPAAnyObject, List list) {
        if (jPAAnyObject.pcStateManager == null) {
            jPAAnyObject.memberships = list;
            return;
        }
        jPAAnyObject.pcStateManager.settingObjectField((PersistenceCapable)jPAAnyObject, pcInheritedFieldCount + 1, jPAAnyObject.memberships, (Object)list, 0);
    }

    private static final String pcGetname(JPAAnyObject jPAAnyObject) {
        if (jPAAnyObject.pcStateManager == null) {
            return jPAAnyObject.name;
        }
        int n = pcInheritedFieldCount + 2;
        jPAAnyObject.pcStateManager.accessingField(n);
        return jPAAnyObject.name;
    }

    private static final void pcSetname(JPAAnyObject jPAAnyObject, String string) {
        if (jPAAnyObject.pcStateManager == null) {
            jPAAnyObject.name = string;
            return;
        }
        jPAAnyObject.pcStateManager.settingStringField((PersistenceCapable)jPAAnyObject, pcInheritedFieldCount + 2, jPAAnyObject.name, string, 0);
    }

    private static final String pcGetplainAttrs(JPAAnyObject jPAAnyObject) {
        if (jPAAnyObject.pcStateManager == null) {
            return jPAAnyObject.plainAttrs;
        }
        int n = pcInheritedFieldCount + 3;
        jPAAnyObject.pcStateManager.accessingField(n);
        return jPAAnyObject.plainAttrs;
    }

    private static final void pcSetplainAttrs(JPAAnyObject jPAAnyObject, String string) {
        if (jPAAnyObject.pcStateManager == null) {
            jPAAnyObject.plainAttrs = string;
            return;
        }
        jPAAnyObject.pcStateManager.settingStringField((PersistenceCapable)jPAAnyObject, pcInheritedFieldCount + 3, jPAAnyObject.plainAttrs, string, 0);
    }

    private static final List pcGetrelationships(JPAAnyObject jPAAnyObject) {
        if (jPAAnyObject.pcStateManager == null) {
            return jPAAnyObject.relationships;
        }
        int n = pcInheritedFieldCount + 4;
        jPAAnyObject.pcStateManager.accessingField(n);
        return jPAAnyObject.relationships;
    }

    private static final void pcSetrelationships(JPAAnyObject jPAAnyObject, List list) {
        if (jPAAnyObject.pcStateManager == null) {
            jPAAnyObject.relationships = list;
            return;
        }
        jPAAnyObject.pcStateManager.settingObjectField((PersistenceCapable)jPAAnyObject, pcInheritedFieldCount + 4, jPAAnyObject.relationships, (Object)list, 0);
    }

    private static final List pcGetresources(JPAAnyObject jPAAnyObject) {
        if (jPAAnyObject.pcStateManager == null) {
            return jPAAnyObject.resources;
        }
        int n = pcInheritedFieldCount + 5;
        jPAAnyObject.pcStateManager.accessingField(n);
        return jPAAnyObject.resources;
    }

    private static final void pcSetresources(JPAAnyObject jPAAnyObject, List list) {
        if (jPAAnyObject.pcStateManager == null) {
            jPAAnyObject.resources = list;
            return;
        }
        jPAAnyObject.pcStateManager.settingObjectField((PersistenceCapable)jPAAnyObject, pcInheritedFieldCount + 5, jPAAnyObject.resources, (Object)list, 0);
    }

    private static final JPAAnyType pcGettype(JPAAnyObject jPAAnyObject) {
        if (jPAAnyObject.pcStateManager == null) {
            return jPAAnyObject.type;
        }
        int n = pcInheritedFieldCount + 6;
        jPAAnyObject.pcStateManager.accessingField(n);
        return jPAAnyObject.type;
    }

    private static final void pcSettype(JPAAnyObject jPAAnyObject, JPAAnyType jPAAnyType) {
        if (jPAAnyObject.pcStateManager == null) {
            jPAAnyObject.type = jPAAnyType;
            return;
        }
        jPAAnyObject.pcStateManager.settingObjectField((PersistenceCapable)jPAAnyObject, pcInheritedFieldCount + 6, (Object)jPAAnyObject.type, (Object)jPAAnyType, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

