/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.common.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.AbstractJPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.AnySearchNode;
import org.apache.syncope.core.persistence.jpa.dao.OrderBySupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.springframework.data.domain.Sort;

public class OracleJPAAnySearchDAO
extends AbstractJPAAnySearchDAO {
    public static String from(PlainSchema schema) {
        return "JSON_TABLE(plainAttrs, '$[*]?(@.schema == \"" + schema.getKey() + "\")." + (schema.isUniqueConstraint() ? "uniqueValue" : "values[*]") + "' COLUMNS " + (schema.isUniqueConstraint() ? "uniqueValue" : "valuez") + " PATH '$." + OracleJPAAnySearchDAO.key((AttrSchemaType)schema.getType()) + "') AS " + schema.getKey();
    }

    public OracleJPAAnySearchDAO(RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        super(realmSearchDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, entityManagerFactory, entityManager);
    }

    @Override
    protected SearchSupport.SearchView defaultSV(SearchSupport svs) {
        return svs.table();
    }

    @Override
    protected String anyId(SearchSupport.SearchView sv) {
        return sv.alias() + ".id";
    }

    @Override
    protected void parseOrderByForPlainSchema(SearchSupport svs, OrderBySupport obs, OrderBySupport.Item item, Sort.Order clause, PlainSchema schema, String fieldName) {
        obs.nonMandatorySchemas = !"true".equals(schema.getMandatoryCondition());
        obs.views.add(svs.table());
        item.select = schema.getKey() + "." + (schema.isUniqueConstraint() ? "uniqueValue" : "valuez") + " AS " + schema.getKey();
        item.where = "";
        item.orderBy = fieldName + " " + clause.getDirection().name();
    }

    @Override
    protected void parseOrderByForField(SearchSupport svs, OrderBySupport.Item item, String fieldName, Sort.Order clause) {
        item.select = svs.table().alias() + "." + fieldName;
        item.where = "";
        item.orderBy = svs.table().alias() + "." + fieldName + " " + clause.getDirection().name();
    }

    protected AnySearchNode.Leaf filJSONAttrQuery(SearchSupport.SearchView from, PlainAttrValue attrValue, PlainSchema schema, AttrCond cond, boolean not, List<Object> parameters) {
        String value = Optional.ofNullable(attrValue.getDateValue()).map(DateTimeFormatter.ISO_OFFSET_DATE_TIME::format).orElseGet(() -> ((AttrCond)cond).getExpression());
        boolean lower = !(schema.getType() != AttrSchemaType.String && schema.getType() != AttrSchemaType.Enum || cond.getType() != AttrCond.Type.IEQ && cond.getType() != AttrCond.Type.ILIKE);
        StringBuilder clause = new StringBuilder(lower ? "LOWER(" : "").append(schema.getKey()).append('.').append(schema.isUniqueConstraint() ? "uniqueValue" : "valuez").append(lower ? Character.valueOf(')') : "");
        switch (cond.getType()) {
            case LIKE: 
            case ILIKE: {
                if (not) {
                    clause.append("NOT ");
                }
                clause.append(" LIKE ");
                break;
            }
            case GE: {
                if (not) {
                    clause.append('<');
                    break;
                }
                clause.append(">=");
                break;
            }
            case GT: {
                if (not) {
                    clause.append("<=");
                    break;
                }
                clause.append('>');
                break;
            }
            case LE: {
                if (not) {
                    clause.append('>');
                    break;
                }
                clause.append("<=");
                break;
            }
            case LT: {
                if (not) {
                    clause.append(">=");
                    break;
                }
                clause.append('<');
                break;
            }
            default: {
                if (not) {
                    clause.append('!');
                }
                clause.append('=');
            }
        }
        clause.append(lower ? "LOWER(" : "").append('?').append(OracleJPAAnySearchDAO.setParameter(parameters, value)).append(lower ? ")" : "");
        if (cond.getType() == AttrCond.Type.ILIKE || cond.getType() == AttrCond.Type.LIKE) {
            clause.append(" ESCAPE '\\'");
        }
        return new AnySearchNode.Leaf(from, clause.toString());
    }

    @Override
    protected AbstractJPAAnySearchDAO.AttrCondQuery getQuery(AttrCond cond, boolean not, AbstractAnySearchDAO.CheckResult<AttrCond> checked, List<Object> parameters, SearchSupport svs) {
        if (not) {
            if (cond.getType() == AttrCond.Type.ISNULL) {
                cond.setType(AttrCond.Type.ISNOTNULL);
            } else if (cond.getType() == AttrCond.Type.ISNOTNULL) {
                cond.setType(AttrCond.Type.ISNULL);
            }
        }
        switch (cond.getType()) {
            case ISNOTNULL: {
                return new AbstractJPAAnySearchDAO.AttrCondQuery(false, new AnySearchNode.Leaf(svs.table(), "JSON_EXISTS(plainAttrs, '$[*]?(@.schema == \"" + checked.schema().getKey() + "\")')"));
            }
            case ISNULL: {
                return new AbstractJPAAnySearchDAO.AttrCondQuery(false, new AnySearchNode.Leaf(svs.table(), "NOT JSON_EXISTS(plainAttrs, '$[*]?(@.schema == \"" + checked.schema().getKey() + "\")')"));
            }
        }
        if (not && checked.schema().isMultivalue()) {
            AnySearchNode.Leaf notNode = this.filJSONAttrQuery(svs.table(), checked.value(), checked.schema(), cond, false, parameters);
            AnySearchNode.Leaf node = new AnySearchNode.Leaf(notNode.getFrom(), "id NOT IN (SELECT id FROM " + notNode.getFrom().name() + "," + OracleJPAAnySearchDAO.from(checked.schema()) + " WHERE " + notNode.getClause().replace(notNode.getFrom().alias() + ".", "") + ")");
            return new AbstractJPAAnySearchDAO.AttrCondQuery(false, node);
        }
        AnySearchNode.Leaf node = this.filJSONAttrQuery(svs.table(), checked.value(), checked.schema(), cond, not, parameters);
        return new AbstractJPAAnySearchDAO.AttrCondQuery(true, node);
    }

    @Override
    protected void visitNode(AnySearchNode node, Map<SearchSupport.SearchView, Boolean> counters, Set<SearchSupport.SearchView> from, List<String> where, SearchSupport svs) {
        counters.clear();
        super.visitNode(node, counters, from, where, svs);
    }

    @Override
    protected String buildFrom(Set<SearchSupport.SearchView> from, Set<String> plainSchemas, OrderBySupport obs) {
        StringBuilder clause = new StringBuilder(super.buildFrom(from, plainSchemas, obs));
        plainSchemas.forEach(schema -> this.plainSchemaDAO.findById(schema).ifPresent(pschema -> clause.append(",").append(OracleJPAAnySearchDAO.from(pschema))));
        if (obs != null) {
            obs.items.forEach(item -> {
                String schema = StringUtils.substringBefore((String)item.orderBy, (int)32);
                if (StringUtils.isNotBlank((CharSequence)schema) && !plainSchemas.contains(schema)) {
                    this.plainSchemaDAO.findById(schema).ifPresent(pschema -> clause.append(" LEFT OUTER JOIN ").append(OracleJPAAnySearchDAO.from(pschema)).append(" ON 1=1"));
                }
            });
        }
        return clause.toString();
    }
}

