/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractConfigAttributeRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.configurers.AbstractInterceptUrlConfigurer;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

@Deprecated
public final class UrlAuthorizationConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractInterceptUrlConfigurer<UrlAuthorizationConfigurer<H>, H> {
    private final StandardInterceptUrlRegistry registry;

    public UrlAuthorizationConfigurer(ApplicationContext context) {
        this.registry = new StandardInterceptUrlRegistry(context);
    }

    public StandardInterceptUrlRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public UrlAuthorizationConfigurer<H> withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return this;
    }

    @Override
    @Deprecated(since="6.4", forRemoval=true)
    public UrlAuthorizationConfigurer<H> withObjectPostProcessor(org.springframework.security.config.annotation.ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return this;
    }

    @Override
    List<AccessDecisionVoter<?>> getDecisionVoters(H http) {
        ArrayList decisionVoters = new ArrayList();
        decisionVoters.add((AccessDecisionVoter<?>)new RoleVoter());
        decisionVoters.add((AccessDecisionVoter<?>)new AuthenticatedVoter());
        return decisionVoters;
    }

    @Override
    FilterInvocationSecurityMetadataSource createMetadataSource(H http) {
        return new DefaultFilterInvocationSecurityMetadataSource(this.registry.createRequestMap());
    }

    private StandardInterceptUrlRegistry addMapping(Iterable<? extends RequestMatcher> requestMatchers, Collection<ConfigAttribute> configAttributes) {
        for (RequestMatcher requestMatcher : requestMatchers) {
            this.registry.addMapping(new AbstractConfigAttributeRequestMatcherRegistry.UrlMapping(requestMatcher, configAttributes));
        }
        return this.registry;
    }

    private static String hasRole(String role) {
        Assert.isTrue((!role.startsWith("ROLE_") ? 1 : 0) != 0, () -> role + " should not start with ROLE_ since ROLE_ is automatically prepended when using hasRole. Consider using hasAuthority or access instead.");
        return "ROLE_" + role;
    }

    private static String[] hasAnyRole(String ... roles) {
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = "ROLE_" + roles[i];
        }
        return roles;
    }

    private static String[] hasAnyAuthority(String ... authorities) {
        return authorities;
    }

    public final class StandardInterceptUrlRegistry
    extends AbstractInterceptUrlConfigurer.AbstractInterceptUrlRegistry<StandardInterceptUrlRegistry, AuthorizedUrl> {
        private StandardInterceptUrlRegistry(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        @Override
        public AuthorizedUrl requestMatchers(String ... patterns) {
            return (AuthorizedUrl)super.requestMatchers(patterns);
        }

        @Override
        public AuthorizedUrl requestMatchers(HttpMethod method, String ... patterns) {
            return (AuthorizedUrl)super.requestMatchers(method, patterns);
        }

        @Override
        public AuthorizedUrl requestMatchers(HttpMethod method) {
            return (AuthorizedUrl)super.requestMatchers(method);
        }

        @Override
        public AuthorizedUrl requestMatchers(RequestMatcher ... requestMatchers) {
            return (AuthorizedUrl)super.requestMatchers(requestMatchers);
        }

        @Override
        protected AuthorizedUrl chainRequestMatchersInternal(List<RequestMatcher> requestMatchers) {
            return new AuthorizedUrl(requestMatchers);
        }

        public StandardInterceptUrlRegistry withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
            UrlAuthorizationConfigurer.this.addObjectPostProcessor(objectPostProcessor);
            return this;
        }

        public H and() {
            return (HttpSecurityBuilder)UrlAuthorizationConfigurer.this.and();
        }
    }

    public class AuthorizedUrl {
        private final List<? extends RequestMatcher> requestMatchers;

        AuthorizedUrl(List<? extends RequestMatcher> requestMatchers) {
            Assert.notEmpty(requestMatchers, (String)"requestMatchers must contain at least one value");
            this.requestMatchers = requestMatchers;
        }

        public StandardInterceptUrlRegistry hasRole(String role) {
            return this.access(UrlAuthorizationConfigurer.hasRole(role));
        }

        public StandardInterceptUrlRegistry hasAnyRole(String ... roles) {
            return this.access(UrlAuthorizationConfigurer.hasAnyRole(roles));
        }

        public StandardInterceptUrlRegistry hasAuthority(String authority) {
            return this.access(authority);
        }

        public StandardInterceptUrlRegistry hasAnyAuthority(String ... authorities) {
            return this.access(UrlAuthorizationConfigurer.hasAnyAuthority(authorities));
        }

        public StandardInterceptUrlRegistry anonymous() {
            return this.hasRole("ANONYMOUS");
        }

        public StandardInterceptUrlRegistry access(String ... attributes) {
            UrlAuthorizationConfigurer.this.addMapping(this.requestMatchers, SecurityConfig.createList((String[])attributes));
            return UrlAuthorizationConfigurer.this.registry;
        }

        protected List<? extends RequestMatcher> getMatchers() {
            return this.requestMatchers;
        }
    }
}

