/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.pm.PasswordResetUrlBuilder;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AccountProfilePasswordChangeRequestAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountProfilePasswordChangeRequestAction.class);
    private final TicketRegistry ticketRegistry;
    private final PasswordResetUrlBuilder passwordResetUrlBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        Ticket tgt = WebUtils.getTicketGrantingTicket((RequestContext)requestContext);
        try {
            if (tgt instanceof AuthenticationAwareTicket) {
                AuthenticationAwareTicket aat = (AuthenticationAwareTicket)tgt;
                Principal principal = aat.getAuthentication().getPrincipal();
                String url = this.passwordResetUrlBuilder.build(principal.getId()).toExternalForm();
                LOGGER.debug("Redirecting password reset flow to [{}]", (Object)url);
                WebUtils.putServiceRedirectUrl((RequestContext)requestContext, (String)url);
                Event event = this.success(url);
                return event;
            }
        }
        finally {
            this.ticketRegistry.deleteTicket(tgt);
        }
        return null;
    }

    @Generated
    public AccountProfilePasswordChangeRequestAction(TicketRegistry ticketRegistry, PasswordResetUrlBuilder passwordResetUrlBuilder) {
        this.ticketRegistry = ticketRegistry;
        this.passwordResetUrlBuilder = passwordResetUrlBuilder;
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public PasswordResetUrlBuilder getPasswordResetUrlBuilder() {
        return this.passwordResetUrlBuilder;
    }
}

