/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Scheduler;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockScheduler
implements Scheduler,
MockTime.Listener {
    private static final Logger log = LoggerFactory.getLogger(MockScheduler.class);
    private final MockTime time;
    private final TreeMap<Long, List<KafkaFutureImpl<Long>>> waiters = new TreeMap();

    public MockScheduler(MockTime time) {
        this.time = time;
        time.addListener(this);
    }

    public Time time() {
        return this.time;
    }

    @Override
    public synchronized void onTimeUpdated() {
        Map.Entry<Long, List<KafkaFutureImpl<Long>>> entry;
        long timeMs = this.time.milliseconds();
        while ((entry = this.waiters.firstEntry()) != null && entry.getKey() <= timeMs) {
            for (KafkaFutureImpl<Long> future : entry.getValue()) {
                future.complete((Object)timeMs);
            }
            this.waiters.remove(entry.getKey());
        }
    }

    public synchronized void addWaiter(long delayMs, KafkaFutureImpl<Long> waiter) {
        long timeMs = this.time.milliseconds();
        if (delayMs <= 0L) {
            waiter.complete((Object)timeMs);
        } else {
            long triggerTimeMs = timeMs + delayMs;
            List futures = this.waiters.computeIfAbsent(triggerTimeMs, k -> new ArrayList());
            futures.add(waiter);
        }
    }

    public <T> Future<T> schedule(ScheduledExecutorService executor, Callable<T> callable, long delayMs) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        KafkaFutureImpl waiter = new KafkaFutureImpl();
        waiter.thenApply(now -> {
            executor.submit(() -> {
                if (!future.isCancelled()) {
                    try {
                        log.trace("Invoking {} at {}", (Object)callable, now);
                        future.complete(callable.call());
                    }
                    catch (Throwable throwable) {
                        future.completeExceptionally(throwable);
                    }
                }
                return null;
            });
            return null;
        });
        log.trace("Scheduling {} for {} ms from now.", callable, (Object)delayMs);
        this.addWaiter(delayMs, (KafkaFutureImpl<Long>)waiter);
        return future;
    }
}

