/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.SnappyCompression;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnappyCompressionTest {
    @Test
    public void testCompressionDecompression() throws IOException {
        SnappyCompression compression = Compression.snappy().build();
        byte[] data = String.join((CharSequence)"", Collections.nCopies(256, "data")).getBytes(StandardCharsets.UTF_8);
        for (byte magic : Arrays.asList((byte)0, (byte)1, (byte)2)) {
            ByteBufferOutputStream bufferStream = new ByteBufferOutputStream(4);
            try (OutputStream out = compression.wrapForOutput(bufferStream, magic);){
                out.write(data);
                out.flush();
            }
            bufferStream.buffer().flip();
            InputStream inputStream = compression.wrapForInput(bufferStream.buffer(), magic, BufferSupplier.create());
            var7_7 = null;
            try {
                byte[] result = new byte[data.length];
                int read = inputStream.read(result);
                Assertions.assertEquals((int)data.length, (int)read);
                Assertions.assertArrayEquals((byte[])data, (byte[])result);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (inputStream == null) continue;
                if (var7_7 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
    }
}

