/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.interceptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.agenda.AgendaOperationExecutionListener;
import org.flowable.common.engine.impl.agenda.AgendaOperationRunner;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.flowable.common.engine.impl.variablelistener.VariableListenerSession;
import org.flowable.common.engine.impl.variablelistener.VariableListenerSessionData;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.VariableListenerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandInvoker
extends AbstractCommandInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandInvoker.class);
    protected AgendaOperationRunner agendaOperationRunner;
    protected Collection<AgendaOperationExecutionListener> agendaOperationExecutionListeners;

    public CommandInvoker(AgendaOperationRunner agendaOperationRunner, Collection<AgendaOperationExecutionListener> agendaOperationExecutionListeners) {
        this.agendaOperationRunner = agendaOperationRunner;
        this.agendaOperationExecutionListeners = agendaOperationExecutionListeners;
    }

    public <T> T execute(CommandConfig config, final Command<T> command, CommandExecutor commandExecutor) {
        final CommandContext commandContext = Context.getCommandContext();
        FlowableEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        if (commandContext.isReused() && !agenda.isEmpty()) {
            return (T)command.execute(commandContext);
        }
        this.executeExecutionListenersBeforeAll(commandContext);
        agenda.planOperation(new Runnable(){

            @Override
            public void run() {
                commandContext.setResult(command.execute(commandContext));
            }
        });
        this.executeOperations(commandContext);
        Map<String, ExecutionEntity> involvedExecutions = CommandContextUtil.getInvolvedExecutions(commandContext);
        if (!commandContext.isReused() && involvedExecutions != null && !involvedExecutions.isEmpty()) {
            agenda.planExecuteInactiveBehaviorsOperation(involvedExecutions.values());
            CommandContextUtil.clearInvolvedExecutions(commandContext);
            this.executeOperations(commandContext);
        }
        VariableListenerSession variableListenerSession = (VariableListenerSession)commandContext.getSession(VariableListenerSession.class);
        Map variableSessionData = variableListenerSession.getVariableData();
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        if (variableSessionData != null) {
            for (String variableName : variableSessionData.keySet()) {
                List variableListenerDataList = (List)variableSessionData.get(variableName);
                for (VariableListenerSessionData variableListenerData : variableListenerDataList) {
                    if (!"bpmn".equals(variableListenerData.getScopeType()) || processInstanceIds.contains(variableListenerData.getScopeId()) || !VariableListenerUtil.hasVariableListenerEventDefinitionsForVariableName(variableListenerData.getScopeDefinitionId(), variableName)) continue;
                    processInstanceIds.add(variableListenerData.getScopeId());
                    agenda.planEvaluateVariableListenerEventsOperation(variableListenerData.getScopeDefinitionId(), variableListenerData.getScopeId());
                }
            }
            if (!processInstanceIds.isEmpty()) {
                this.executeOperations(commandContext);
            }
            this.executeExecutionListenersAfterAll(commandContext);
        }
        return (T)commandContext.getResult();
    }

    protected void executeOperations(CommandContext commandContext) {
        FlowableEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        while (!agenda.isEmpty()) {
            Runnable runnable = agenda.getNextOperation();
            this.executeExecutionListenersBeforeExecute(commandContext, runnable);
            try {
                this.executeOperation(commandContext, runnable);
            }
            catch (Throwable throwable) {
                this.executeExecutionListenersAfterException(commandContext, runnable, throwable);
                ExceptionUtil.sneakyThrow((Throwable)throwable);
            }
            this.executeExecutionListenersAfterExecute(commandContext, runnable);
        }
    }

    protected void executeExecutionListenersBeforeAll(CommandContext commandContext) {
        if (this.agendaOperationExecutionListeners != null && !this.agendaOperationExecutionListeners.isEmpty()) {
            for (AgendaOperationExecutionListener listener : this.agendaOperationExecutionListeners) {
                listener.beforeAll(commandContext);
            }
        }
    }

    protected void executeExecutionListenersAfterAll(CommandContext commandContext) {
        if (this.agendaOperationExecutionListeners != null && !this.agendaOperationExecutionListeners.isEmpty()) {
            for (AgendaOperationExecutionListener listener : this.agendaOperationExecutionListeners) {
                listener.afterAll(commandContext);
            }
        }
    }

    protected void executeExecutionListenersBeforeExecute(CommandContext commandContext, Runnable runnable) {
        if (this.agendaOperationExecutionListeners != null && !this.agendaOperationExecutionListeners.isEmpty()) {
            for (AgendaOperationExecutionListener listener : this.agendaOperationExecutionListeners) {
                listener.beforeExecute(commandContext, runnable);
            }
        }
    }

    protected void executeExecutionListenersAfterExecute(CommandContext commandContext, Runnable runnable) {
        if (this.agendaOperationExecutionListeners != null && !this.agendaOperationExecutionListeners.isEmpty()) {
            for (AgendaOperationExecutionListener listener : this.agendaOperationExecutionListeners) {
                listener.afterExecute(commandContext, runnable);
            }
        }
    }

    protected void executeExecutionListenersAfterException(CommandContext commandContext, Runnable runnable, Throwable throwable) {
        if (this.agendaOperationExecutionListeners != null && !this.agendaOperationExecutionListeners.isEmpty()) {
            for (AgendaOperationExecutionListener listener : this.agendaOperationExecutionListeners) {
                listener.afterExecuteException(commandContext, runnable, throwable);
            }
        }
    }

    public void executeOperation(CommandContext commandContext, Runnable runnable) {
        if (runnable instanceof AbstractOperation) {
            AbstractOperation operation = (AbstractOperation)runnable;
            if (operation.getExecution() == null || !operation.getExecution().isEnded()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Executing operation {}", operation.getClass());
                }
                this.agendaOperationRunner.executeOperation(commandContext, (Runnable)operation);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing operation {}", runnable.getClass());
            }
            runnable.run();
        }
    }

    public CommandInterceptor getNext() {
        return null;
    }

    public void setNext(CommandInterceptor next) {
        throw new UnsupportedOperationException("CommandInvoker must be the last interceptor in the chain");
    }

    public AgendaOperationRunner getAgendaOperationRunner() {
        return this.agendaOperationRunner;
    }

    public void setAgendaOperationRunner(AgendaOperationRunner agendaOperationRunner) {
        this.agendaOperationRunner = agendaOperationRunner;
    }
}

