/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.math.BigInteger;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ASN1BigInteger
extends ASN1Element {
    private static final long serialVersionUID = 2631806934961821260L;
    @NotNull
    private final BigInteger value;

    public ASN1BigInteger(@NotNull BigInteger value) {
        this(2, value);
    }

    public ASN1BigInteger(byte type, @NotNull BigInteger value) {
        super(type, value.toByteArray());
        this.value = value;
    }

    private ASN1BigInteger(byte type, @NotNull BigInteger bigIntegerValue, @NotNull byte[] berValue) {
        super(type, berValue);
        this.value = bigIntegerValue;
    }

    public ASN1BigInteger(long value) {
        this(2, BigInteger.valueOf(value));
    }

    public ASN1BigInteger(byte type, long value) {
        this(type, BigInteger.valueOf(value));
    }

    @NotNull
    public BigInteger getBigIntegerValue() {
        return this.value;
    }

    @NotNull
    public static ASN1BigInteger decodeAsBigInteger(@NotNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            if (length == 0) {
                throw new ASN1Exception(ASN1Messages.ERR_BIG_INTEGER_DECODE_EMPTY_VALUE.get());
            }
            byte[] elementValue = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, elementValue, 0, length);
            BigInteger bigIntegerValue = new BigInteger(elementValue);
            return new ASN1BigInteger(elementBytes[0], bigIntegerValue, elementValue);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw ae;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NotNull
    public static ASN1BigInteger decodeAsBigInteger(@NotNull ASN1Element element) throws ASN1Exception {
        byte[] value = element.getValue();
        if (value.length == 0) {
            throw new ASN1Exception(ASN1Messages.ERR_BIG_INTEGER_DECODE_EMPTY_VALUE.get());
        }
        return new ASN1BigInteger(element.getType(), new BigInteger(value), value);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append(this.value);
    }
}

