/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.logout;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.RootCasException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.slo.SingleLogoutUrl;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.oidc.web.controllers.logout.OidcPostLogoutRedirectUrlMatcher;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.WebUtils;
import org.jose4j.jwt.JwtClaims;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcLogoutEndpointController
extends BaseOidcController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcLogoutEndpointController.class);
    private final UrlValidator urlValidator;
    private final OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher;

    public OidcLogoutEndpointController(OidcConfigurationContext context, OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher, UrlValidator urlValidator) {
        super(context);
        this.urlValidator = urlValidator;
        this.postLogoutRedirectUrlMatcher = postLogoutRedirectUrlMatcher;
    }

    @GetMapping(value={"/oidc/oidcLogout", "/oidc/logout", "/**/oidcLogout"})
    public ResponseEntity handleRequestInternal(@RequestParam(value="post_logout_redirect_uri", required=false) String postLogoutRedirectUrl, @RequestParam(value="state", required=false) String state, @RequestParam(value="id_token_hint", required=false) String idToken, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String clientId = null;
        if (StringUtils.isNotBlank((CharSequence)idToken)) {
            Optional<String> validURL;
            LOGGER.trace("Decoding logout id token [{}]", (Object)idToken);
            String clientIdInIdToken = JwtBuilder.parse((String)idToken).getClaimAsString("client_id");
            OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager(), (String)clientIdInIdToken, OidcRegisteredService.class);
            JwtClaims claims = ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenSigningAndEncryptionService().decode(idToken, Optional.ofNullable(registeredService));
            clientId = claims.getStringClaimValue("client_id");
            LOGGER.debug("Client id retrieved from id token is [{}]", (Object)clientId);
            LOGGER.debug("Located registered service [{}]", (Object)registeredService);
            WebApplicationService service = (WebApplicationService)((OidcConfigurationContext)this.getConfigurationContext()).getWebApplicationServiceServiceFactory().createService(clientId);
            AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = ((OidcConfigurationContext)this.getConfigurationContext()).getRegisteredServiceAccessStrategyEnforcer().execute(audit);
            accessResult.throwExceptionIfNeeded();
            this.enforceIssuer(request, response, registeredService);
            WebUtils.putRegisteredService((HttpServletRequest)request, (RegisteredService)((RegisteredService)Objects.requireNonNull(registeredService)));
            List urls = ((OidcConfigurationContext)this.getConfigurationContext()).getSingleLogoutServiceLogoutUrlBuilder().determineLogoutUrl((RegisteredService)registeredService, service, Optional.of(request)).stream().map(SingleLogoutUrl::getUrl).collect(Collectors.toList());
            LOGGER.debug("Logout urls assigned to registered service are [{}]", urls);
            if (StringUtils.isNotBlank((CharSequence)postLogoutRedirectUrl) && registeredService.getMatchingStrategy() != null) {
                boolean matchResult;
                WebApplicationService postLogoutService = (WebApplicationService)((OidcConfigurationContext)this.getConfigurationContext()).getWebApplicationServiceServiceFactory().createService(postLogoutRedirectUrl);
                boolean bl = matchResult = registeredService.matches(postLogoutRedirectUrl) || urls.stream().anyMatch(url -> this.postLogoutRedirectUrlMatcher.matches(postLogoutRedirectUrl, (String)url)) || ((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager().findServiceBy((Service)postLogoutService) != null;
                if (matchResult) {
                    LOGGER.debug("Requested logout URL [{}] is authorized for redirects", (Object)postLogoutRedirectUrl);
                    return this.executeLogoutRedirect(Optional.ofNullable(StringUtils.trimToNull((String)state)), Optional.of(postLogoutRedirectUrl), Optional.of(clientId), request, response);
                }
            }
            if ((validURL = urls.stream().filter(arg_0 -> ((UrlValidator)this.urlValidator).isValid(arg_0)).findFirst()).isPresent()) {
                return this.executeLogoutRedirect(Optional.ofNullable(StringUtils.trimToNull((String)state)), validURL, Optional.of(clientId), request, response);
            }
            LOGGER.debug("No logout urls could be determined for registered service [{}]", (Object)registeredService.getName());
        }
        this.enforceIssuer(request, response, null);
        return this.executeLogoutRedirect(Optional.ofNullable(StringUtils.trimToNull((String)state)), Optional.empty(), Optional.ofNullable(clientId), request, response);
    }

    private void enforceIssuer(HttpServletRequest request, HttpServletResponse response, OidcRegisteredService registeredService) {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "oidcLogout")) {
            LOGGER.warn("Logout request is not issued by a trusted issuer: [{}]", (Object)((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().determineIssuer(Optional.ofNullable(registeredService)));
            throw RootCasException.withCode((String)"screen.oidc.issuer.invalid");
        }
    }

    protected ResponseEntity executeLogoutRedirect(Optional<String> state, Optional<String> redirectUrl, Optional<String> clientId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        redirectUrl.ifPresent(url -> {
            UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url);
            state.ifPresent(st -> builder.queryParam("state", new Object[]{st}));
            clientId.ifPresent(id -> builder.queryParam("client_id", new Object[]{id}));
            String logoutUrl = builder.build().toUriString();
            LOGGER.debug("Final logout redirect URL is [{}]", (Object)logoutUrl);
            WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)logoutUrl);
        });
        request.getServletContext().getRequestDispatcher("/logout").forward((ServletRequest)request, (ServletResponse)response);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.PERMANENT_REDIRECT).build();
    }
}

