/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.assurance;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.oidc.assurance.AssuranceVerificationSource;
import org.apereo.cas.oidc.assurance.entity.Verification;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;

public class AssuranceVerificationJsonSource
implements AssuranceVerificationSource,
DisposableBean,
AutoCloseable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AssuranceVerificationJsonSource.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final List<Verification> verifications = Collections.synchronizedList(new ArrayList());
    private FileWatcherService watcherService;

    public AssuranceVerificationJsonSource(Resource resource) throws Exception {
        if (ResourceUtils.doesResourceExist((Resource)resource)) {
            this.loadFromInputStream(resource);
            if (ResourceUtils.isFile((Resource)resource)) {
                this.watcherService = new FileWatcherService(resource.getFile(), __ -> this.loadFromInputStream(resource));
                this.watcherService.start(this.getClass().getSimpleName());
            }
        }
    }

    @Override
    public List<Verification> load() {
        return List.copyOf(this.verifications);
    }

    @Override
    public Optional<Verification> findByTrustFramework(String trustFramework) {
        return this.verifications.stream().filter(verification -> StringUtils.equalsIgnoreCase((CharSequence)trustFramework, (CharSequence)verification.getTrustFramework())).findFirst();
    }

    @Override
    public void close() {
        if (this.watcherService != null) {
            this.watcherService.close();
        }
    }

    public void destroy() {
        this.close();
    }

    private void loadFromInputStream(Resource resource) {
        FunctionUtils.doAndHandle(__ -> {
            String json = new String(resource.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
            List results = (List)MAPPER.readValue(JsonValue.readHjson((String)json).toString(), (TypeReference)new TypeReference<List<Verification>>(this){});
            this.verifications.clear();
            this.verifications.addAll(results);
        });
    }
}

