/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.servlet.Filter;
import java.util.Collection;
import java.util.EventListener;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.web.Log4jServletContextListener;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.logging.web.LoggingConfigurationEndpoint;
import org.apereo.cas.logging.web.ThreadContextMDCServletFilter;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Core})
@AutoConfiguration
public class CasCoreLoggingAutoConfiguration {

    @ConditionalOnClass(value={LoggerContext.class})
    @Configuration(value="CasLog4jConfiguration", proxyBeanMethods=false)
    static class CasLog4jConfiguration {
        CasLog4jConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LoggingConfigurationEndpoint loggingConfigurationEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new LoggingConfigurationEndpoint(casProperties, applicationContext);
        }

        @Bean
        public ServletListenerRegistrationBean<Log4jServletContextListener> log4jServletContextListener() {
            ServletListenerRegistrationBean bean = new ServletListenerRegistrationBean();
            bean.setEnabled(true);
            bean.setListener((EventListener)new Log4jServletContextListener());
            return bean;
        }
    }

    @Configuration(value="CasMdcLoggingConfiguration", proxyBeanMethods=false)
    static class CasMdcLoggingConfiguration {
        CasMdcLoggingConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FilterRegistrationBean<ThreadContextMDCServletFilter> threadContextMDCServletFilter(CasConfigurationProperties casProperties, @Qualifier(value="defaultTicketRegistrySupport") ObjectProvider<TicketRegistrySupport> ticketRegistrySupport, @Qualifier(value="ticketGrantingTicketCookieGenerator") ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator) {
            ThreadContextMDCServletFilter filter = new ThreadContextMDCServletFilter(ticketRegistrySupport, ticketGrantingTicketCookieGenerator, casProperties);
            FilterRegistrationBean bean = new FilterRegistrationBean();
            bean.setFilter((Filter)filter);
            bean.setAsyncSupported(true);
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("threadContextMDCServletFilter");
            bean.setOrder(-2147483646);
            bean.setEnabled(casProperties.getLogging().getMdc().isEnabled());
            return bean;
        }
    }
}

