/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.form;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.markup.html.bootstrap.layout.col.SpanType;
import de.agilecoders.wicket.core.util.Attributes;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.markup.ComponentTag;

public class InputBehavior
extends BootstrapBaseBehavior {
    private ICssClassNameProvider heightSize;
    private SpanType columnSize;
    private static final List<Integer> messageTypes = Arrays.asList(500, 400, 300, 250, 200, 100, 0);

    public InputBehavior() {
        this(null, null);
    }

    public InputBehavior(SpanType columnSize) {
        this(null, columnSize);
    }

    public InputBehavior(Size heightSize) {
        this(heightSize, null);
    }

    public InputBehavior(Size heightSize, SpanType columnSize) {
        this.heightSize = heightSize;
        this.columnSize = columnSize;
    }

    public InputBehavior size(SpanType spanType) {
        this.columnSize = spanType;
        return this;
    }

    public InputBehavior size(Size heightSize) {
        this.heightSize = heightSize;
        return this;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        if (this.heightSize != null) {
            Attributes.addClass(tag, this.heightSize.cssClassName());
        }
        Attributes.addClass(tag, "form-control");
        FeedbackMessages messages = component.getFeedbackMessages();
        if (!messages.isEmpty()) {
            Attributes.addClass(tag, this.toClassName(this.getWorstMessage(messages)));
        }
    }

    public void beforeRender(Component component) {
        super.beforeRender(component);
        if (this.columnSize != null) {
            component.getResponse().write((CharSequence)("<div class=\"" + this.columnSize.cssClassName() + "\">"));
        }
    }

    public void afterRender(Component component) {
        super.afterRender(component);
        if (this.columnSize != null) {
            component.getResponse().write((CharSequence)"</div>");
        }
    }

    protected Function<FeedbackMessage, String> newFeedbackMessageToCssClassNameTransformer() {
        return new FeedbackMessageToCssClassNameTransformer();
    }

    private FeedbackMessage getWorstMessage(FeedbackMessages messages) {
        for (Integer messageType : messageTypes) {
            FeedbackMessage ret = messages.first(messageType.intValue());
            if (ret == null) continue;
            return ret;
        }
        return messages.first();
    }

    private String toClassName(FeedbackMessage message) {
        return this.newFeedbackMessageToCssClassNameTransformer().apply(message);
    }

    public static enum Size implements ICssClassNameProvider
    {
        Small("sm"),
        Medium("md"),
        Large("lg");

        private final String cssName;

        private Size(String cssName) {
            this.cssName = cssName;
        }

        @Override
        public String cssClassName() {
            return this == Medium ? "" : "form-control-" + this.cssName;
        }
    }

    public static class FeedbackMessageToCssClassNameTransformer
    implements Function<FeedbackMessage, String> {
        @Override
        public String apply(FeedbackMessage message) {
            if (message == null) {
                return "";
            }
            switch (message.getLevel()) {
                case 300: 
                case 400: 
                case 500: {
                    return "is-invalid";
                }
                case 200: 
                case 250: {
                    return "is-valid";
                }
            }
            return "";
        }
    }
}

