/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.audit;

import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;

public class OAuth20AccessTokenGrantRequestAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    public String[] resolveFrom(JoinPoint auditableTarget, Object retval) {
        AuditableExecutionResult auditResult = (AuditableExecutionResult)retval;
        Optional executionResult = auditResult.getExecutionResult();
        if (executionResult.isPresent()) {
            AccessTokenRequestContext accessTokenRequest = (AccessTokenRequestContext)executionResult.get();
            String tokenId = accessTokenRequest.getToken() == null ? "N/A" : accessTokenRequest.getToken().getId();
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("service", accessTokenRequest.getService().getId());
            values.put("code", tokenId);
            values.put("client_id", accessTokenRequest.getClientId());
            values.put("grant_type", accessTokenRequest.getGrantType().getType());
            values.put("response_type", accessTokenRequest.getResponseType().getType());
            values.put("redirect_uri", accessTokenRequest.getRedirectUri());
            values.put("scope", accessTokenRequest.getScopes());
            return new String[]{this.auditFormat.serialize(values)};
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

