/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GoogleAuthenticatorValidateSelectedRegistrationAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorValidateSelectedRegistrationAction.class);
    private static final String CODE = "screen.authentication.gauth.invalid";

    private static void addErrorMessageToContext(RequestContext requestContext) {
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)CODE);
    }

    protected Event doExecute(RequestContext requestContext) {
        OneTimeTokenAccount account = WebUtils.getOneTimeTokenAccount((RequestContext)requestContext, OneTimeTokenAccount.class);
        if (account == null) {
            LOGGER.warn("Unable to determine google authenticator account");
            GoogleAuthenticatorValidateSelectedRegistrationAction.addErrorMessageToContext(requestContext);
            return this.error();
        }
        GoogleAuthenticatorTokenCredential credential = (GoogleAuthenticatorTokenCredential)WebUtils.getCredential((RequestContext)requestContext, GoogleAuthenticatorTokenCredential.class);
        if (credential == null) {
            LOGGER.warn("Unable to determine google authenticator token credential");
            GoogleAuthenticatorValidateSelectedRegistrationAction.addErrorMessageToContext(requestContext);
            return this.error();
        }
        LOGGER.trace("Located account [{}] to be used for credential [{}]", (Object)account, (Object)credential);
        if (credential.getAccountId() == null || credential.getAccountId().longValue() != account.getId()) {
            LOGGER.warn("Google authenticator token credential is not assigned a valid account id");
            GoogleAuthenticatorValidateSelectedRegistrationAction.addErrorMessageToContext(requestContext);
            return this.error();
        }
        return null;
    }
}

