/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.snapshot;

import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.repository.FlowExecutionRestorationFailureException;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SerializedFlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.SnapshotCreationException;
import org.springframework.webflow.execution.repository.snapshot.SnapshotUnmarshalException;

public class SerializedFlowExecutionSnapshotFactory
implements FlowExecutionSnapshotFactory {
    private FlowExecutionFactory flowExecutionFactory;
    private FlowDefinitionLocator flowDefinitionLocator;
    private boolean compress = true;

    public SerializedFlowExecutionSnapshotFactory(FlowExecutionFactory flowExecutionFactory, FlowDefinitionLocator flowDefinitionLocator) {
        Assert.notNull((Object)flowExecutionFactory, (String)"The FlowExecutionFactory to restore transient flow state is required");
        Assert.notNull((Object)flowDefinitionLocator, (String)"The FlowDefinitionLocator to restore FlowDefinitions is required");
        this.flowExecutionFactory = flowExecutionFactory;
        this.flowDefinitionLocator = flowDefinitionLocator;
    }

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    @Override
    public FlowExecutionSnapshot createSnapshot(FlowExecution flowExecution) throws SnapshotCreationException {
        return new SerializedFlowExecutionSnapshot(flowExecution, this.compress);
    }

    @Override
    public FlowExecution restoreExecution(FlowExecutionSnapshot snapshot, String flowId, FlowExecutionKey key, MutableAttributeMap<Object> conversationScope, FlowExecutionKeyFactory keyFactory) throws FlowExecutionRestorationFailureException {
        FlowExecution execution;
        SerializedFlowExecutionSnapshot snapshotImpl = (SerializedFlowExecutionSnapshot)snapshot;
        FlowDefinition def = this.flowDefinitionLocator.getFlowDefinition(flowId);
        try {
            execution = snapshotImpl.unmarshal(def.getClassLoader());
        }
        catch (SnapshotUnmarshalException e) {
            throw new FlowExecutionRestorationFailureException(key, e);
        }
        this.flowExecutionFactory.restoreFlowExecution(execution, def, key, conversationScope, this.flowDefinitionLocator);
        return execution;
    }
}

