/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2;

import org.apache.struts2.ActionProxyFactory;
import org.apache.struts2.config.Configuration;
import org.apache.struts2.config.ConfigurationException;
import org.apache.struts2.config.ConfigurationManager;
import org.apache.struts2.config.ConfigurationProvider;
import org.apache.struts2.inject.Container;
import org.apache.struts2.inject.ContainerBuilder;
import org.apache.struts2.inject.Context;
import org.apache.struts2.inject.Factory;
import org.apache.struts2.inject.Scope;
import org.apache.struts2.test.StubConfigurationProvider;
import org.apache.struts2.util.XWorkTestCaseHelper;
import org.apache.struts2.util.location.LocatableProperties;
import org.junit.After;
import org.junit.Before;

public abstract class XWorkJUnit4TestCase {
    protected ConfigurationManager configurationManager;
    protected Configuration configuration;
    protected Container container;
    protected ActionProxyFactory actionProxyFactory;

    @Before
    public void setUp() throws Exception {
        this.configurationManager = XWorkTestCaseHelper.setUp();
        this.configuration = this.configurationManager.getConfiguration();
        this.container = this.configuration.getContainer();
        this.actionProxyFactory = this.container.getInstance(ActionProxyFactory.class);
    }

    @After
    public void tearDown() throws Exception {
        XWorkTestCaseHelper.tearDown(this.configurationManager);
    }

    protected void loadConfigurationProviders(ConfigurationProvider ... providers) {
        this.configurationManager = XWorkTestCaseHelper.loadConfigurationProviders(this.configurationManager, providers);
        this.configuration = this.configurationManager.getConfiguration();
        this.container = this.configuration.getContainer();
        this.actionProxyFactory = this.container.getInstance(ActionProxyFactory.class);
    }

    protected void loadButAdd(Class<?> type, Object impl) {
        this.loadButAdd(type, "default", impl);
    }

    protected void loadButAdd(final Class<?> type, final String name, final Object impl) {
        this.loadConfigurationProviders(new StubConfigurationProvider(){

            @Override
            public void register(ContainerBuilder builder, LocatableProperties props) throws ConfigurationException {
                builder.factory(type, name, new Factory(){

                    public Object create(Context context) throws Exception {
                        return impl;
                    }

                    public Class type() {
                        return impl.getClass();
                    }
                }, Scope.SINGLETON);
            }
        });
    }
}

