/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import java.io.IOException;
import java.util.Deque;
import org.apache.tiles.api.Attribute;
import org.apache.tiles.api.Expression;
import org.apache.tiles.api.ListAttribute;
import org.apache.tiles.autotag.core.runtime.ModelBody;
import org.apache.tiles.request.Request;
import org.apache.tiles.template.ComposeStackUtil;

public class AddAttributeModel {
    public void execute(Object value, String expression, String role, String type, Request request, ModelBody modelBody) throws IOException {
        Attribute attribute = new Attribute();
        Deque<Object> composeStack = ComposeStackUtil.getComposeStack(request);
        composeStack.push(attribute);
        String body = modelBody.evaluateAsString();
        attribute = (Attribute)composeStack.pop();
        this.addAttributeToList(attribute, composeStack, value, expression, body, role, type);
    }

    private void addAttributeToList(Attribute attribute, Deque<Object> composeStack, Object value, String expression, String body, String role, String type) {
        ListAttribute listAttribute = (ListAttribute)ComposeStackUtil.findAncestorWithClass(composeStack, ListAttribute.class);
        if (listAttribute == null) {
            throw new NullPointerException("There is no ListAttribute in the stack");
        }
        if (value != null) {
            attribute.setValue(value);
        } else if (attribute.getValue() == null && body != null) {
            attribute.setValue(body);
        }
        if (expression != null) {
            attribute.setExpressionObject(Expression.createExpressionFromDescribedExpression(expression));
        }
        if (role != null) {
            attribute.setRole(role);
        }
        if (type != null) {
            attribute.setRenderer(type);
        }
        listAttribute.add(attribute);
    }
}

