/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.types.date;

import java.util.Date;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;
import net.sf.jasperreports.types.date.DateRange;
import net.sf.jasperreports.types.date.DateRangeBaseSQLEqualityClause;

public class DateRangeSQLEqualClause
extends DateRangeBaseSQLEqualityClause {
    private static final DateRangeSQLEqualClause INSTANCE = new DateRangeSQLEqualClause();

    public static DateRangeSQLEqualClause instance() {
        return INSTANCE;
    }

    protected DateRangeSQLEqualClause() {
    }

    @Override
    protected void applyDateRange(JRQueryClauseContext queryContext, String column, DateRange dateRange) {
        StringBuffer queryBuffer = queryContext.queryBuffer();
        if (dateRange == null || dateRange.getStart() == null || dateRange.getEnd() == null) {
            queryBuffer.append(column).append(" IS NULL");
        } else {
            Date end;
            Date start = dateRange.getStart();
            if (start.equals(end = dateRange.getEnd())) {
                queryBuffer.append(column).append(" = ?");
                queryContext.addQueryParameter(null, start);
            } else {
                queryBuffer.append(column).append(" >= ? AND ").append(column).append(" <= ?");
                queryContext.addQueryParameter(null, start);
                queryContext.addQueryParameter(null, end);
            }
        }
    }
}

