/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.data.cache.CachedDataset;
import net.sf.jasperreports.data.cache.ColumnCacheData;
import net.sf.jasperreports.data.cache.DataSnapshot;
import net.sf.jasperreports.data.cache.DataSnapshotException;
import net.sf.jasperreports.data.cache.StandardCachedDataset;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.IndexedDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnDataSnapshot
implements DataSnapshot,
Serializable {
    private static final Log log = LogFactory.getLog(ColumnDataSnapshot.class);
    public static final String EXCEPTION_MESSAGE_KEY_SNAPSHOT_CANNOT_BE_PERSISTED = "data.cache.snapshot.cannot.be.persisted";
    private static final long serialVersionUID = 10200L;
    private Map<Object, ColumnCacheData> cachedData = new LinkedHashMap<Object, ColumnCacheData>();
    private transient boolean persistable = true;

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!this.persistable) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_SNAPSHOT_CANNOT_BE_PERSISTED, (Object[])null);
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.persistable = true;
        in.defaultReadObject();
    }

    @Override
    public boolean hasCachedData(Object key) {
        return this.cachedData.containsKey(key);
    }

    @Override
    public CachedDataset getCachedData(Object key) throws DataSnapshotException {
        ColumnCacheData cacheData = this.cachedData.get(key);
        if (cacheData == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No cached data exists for " + key));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found cached data source of " + cacheData.size() + " records for " + key));
        }
        IndexedDataSource dataSource = cacheData.createDataSource();
        Map<String, Object> parameters = cacheData.getParameters();
        StandardCachedDataset dataset = new StandardCachedDataset(dataSource, parameters);
        return dataset;
    }

    public void addCachedData(Object key, ColumnCacheData data) {
        this.cachedData.put(key, data);
    }

    @Override
    public boolean isPersistable() {
        return this.persistable;
    }

    public void setPersistable(boolean persistable) {
        this.persistable = persistable;
    }
}

