/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepoPath
implements Comparable<RepoPath> {
    private final List<String> path;
    private final boolean isRepositoryPath;

    public RepoPath(@NotNull String path) {
        path = path.trim();
        this.isRepositoryPath = path.isEmpty();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path.isEmpty() ? Collections.emptyList() : Arrays.asList(path.split("/"));
    }

    public RepoPath(@NotNull List<String> list) {
        this.path = new ArrayList<String>(list);
        this.isRepositoryPath = false;
    }

    @Override
    public int compareTo(@NotNull RepoPath o) {
        String me = this.toString();
        String them = o.toString();
        return me.compareTo(them);
    }

    @Nullable
    public RepoPath getParent() {
        if (this.path.isEmpty()) {
            return null;
        }
        ArrayList<String> parentPath = new ArrayList<String>(this.path.subList(0, this.path.size() - 1));
        return new RepoPath(parentPath);
    }

    @NotNull
    public List<String> getSegments() {
        return this.path;
    }

    public boolean startsWith(@Nullable RepoPath otherPath) {
        if (otherPath == null || this.isRepositoryPath || otherPath.isRepositoryPath) {
            return false;
        }
        if (this.path.size() < otherPath.path.size()) {
            return false;
        }
        ArrayList<String> l = new ArrayList<String>(this.path.subList(0, otherPath.path.size()));
        return l.equals(otherPath.path);
    }

    public boolean isRepositoryPath() {
        return this.isRepositoryPath;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.isRepositoryPath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepoPath other = (RepoPath)obj;
        return Objects.equals(this.path, other.path) && this.isRepositoryPath == other.isRepositoryPath;
    }

    public String toString() {
        return this.isRepositoryPath ? "" : "/" + this.path.stream().collect(Collectors.joining("/"));
    }
}

