/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.Reader;
import java.io.StringReader;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.repoinit.parser.RepoInitParsingException;
import org.apache.sling.repoinit.parser.impl.RepoInitParserService;
import org.osgi.util.converter.Converters;

public class CheckRepoinit
implements AnalyserTask {
    public static final String PID = "org.apache.sling.jcr.repoinit.impl.RepositoryInitializer";
    public static final String FACTORY_PID = "org.apache.sling.jcr.repoinit.RepositoryInitializer";

    @Override
    public String getName() {
        return "Repoinit Check";
    }

    @Override
    public String getId() {
        return "repoinit";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) {
        Configuration cfg;
        Extension ext = ctx.getFeature().getExtensions().getByName("repoinit");
        if (ext != null) {
            if (ext.getType() != ExtensionType.TEXT) {
                ctx.reportExtensionError("repoinit", "Repoinit extension must be of type TEXT");
            } else {
                this.check(ctx, "extension", ext.getText());
            }
        }
        if ((cfg = ctx.getFeature().getConfigurations().getConfiguration(PID)) != null) {
            this.check(ctx, cfg, false);
        }
        for (Configuration c : ctx.getFeature().getConfigurations()) {
            if (!FACTORY_PID.equals(c.getFactoryPid())) continue;
            this.check(ctx, c, true);
        }
    }

    private void check(AnalyserTaskContext ctx, Configuration cfg, boolean supportsScripts) {
        Object val;
        if (supportsScripts && (val = cfg.getProperties().get("scripts")) != null) {
            String[] scripts;
            for (String contents : scripts = (String[])Converters.standardConverter().convert(val).to(String[].class)) {
                this.check(ctx, "configuration ".concat(cfg.getPid()), contents);
            }
        }
    }

    private void check(AnalyserTaskContext ctx, String id, String contents) {
        RepoInitParserService parser = new RepoInitParserService();
        try {
            parser.parse((Reader)new StringReader(contents));
        }
        catch (RepoInitParsingException e) {
            ctx.reportExtensionError("repoinit", "Parsing error in repoinit from ".concat(id).concat(" : ").concat(e.getMessage()));
        }
    }
}

