/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.MetadataExtensionInformation;
import org.opengis.metadata.citation.OnlineResource;

@XmlType(name="MD_MetadataExtensionInformation_Type", namespace="http://standards.iso.org/iso/19115/-3/mex/1.0", propOrder={"extensionOnLineResource", "extendedElementInformation"})
@XmlRootElement(name="MD_MetadataExtensionInformation", namespace="http://standards.iso.org/iso/19115/-3/mex/1.0")
public class DefaultMetadataExtensionInformation
extends ISOMetadata
implements MetadataExtensionInformation {
    private static final long serialVersionUID = 1471486028607039929L;
    private OnlineResource extensionOnLineResource;
    private Collection<ExtendedElementInformation> extendedElementInformation;

    public DefaultMetadataExtensionInformation() {
    }

    public DefaultMetadataExtensionInformation(MetadataExtensionInformation object) {
        super(object);
        if (object != null) {
            this.extensionOnLineResource = object.getExtensionOnLineResource();
            this.extendedElementInformation = DefaultMetadataExtensionInformation.copyCollection(object.getExtendedElementInformation(), ExtendedElementInformation.class);
        }
    }

    public static DefaultMetadataExtensionInformation castOrCopy(MetadataExtensionInformation object) {
        if (object == null || object instanceof DefaultMetadataExtensionInformation) {
            return (DefaultMetadataExtensionInformation)object;
        }
        return new DefaultMetadataExtensionInformation(object);
    }

    @XmlElement(name="extensionOnLineResource")
    public OnlineResource getExtensionOnLineResource() {
        return this.extensionOnLineResource;
    }

    public void setExtensionOnLineResource(OnlineResource newValue) {
        this.checkWritePermission(this.extensionOnLineResource);
        this.extensionOnLineResource = newValue;
    }

    @XmlElement(name="extendedElementInformation")
    public Collection<ExtendedElementInformation> getExtendedElementInformation() {
        this.extendedElementInformation = this.nonNullCollection(this.extendedElementInformation, ExtendedElementInformation.class);
        return this.extendedElementInformation;
    }

    public void setExtendedElementInformation(Collection<? extends ExtendedElementInformation> newValues) {
        this.extendedElementInformation = this.writeCollection(newValues, this.extendedElementInformation, ExtendedElementInformation.class);
    }
}

