/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.List;
import java.util.function.BiConsumer;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.storage.aggregate.CoverageAggregator;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupByTransform;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;

final class GroupAggregate
extends AggregatedResource
implements Aggregate {
    private static final int KEEP_ALIVE = 2;
    private final Resource[] components;
    private boolean componentsAreLeaves;
    List<SampleDimension> sampleDimensions;

    GroupAggregate(String name, StoreListeners listeners, int count) {
        super(name, listeners, count < 2);
        this.components = new Resource[count];
    }

    GroupAggregate(String name, StoreListeners listeners, GridCoverageResource[] components, List<SampleDimension> sampleDimensions) {
        super(name, listeners, true);
        this.components = components;
        this.componentsAreLeaves = true;
        this.sampleDimensions = sampleDimensions;
    }

    private GroupAggregate(GroupAggregate source, Resource[] components) {
        super(source);
        this.sampleDimensions = source.sampleDimensions;
        this.componentsAreLeaves = source.componentsAreLeaves;
        this.components = components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final Resource apply(MergeStrategy strategy) {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            boolean changed = false;
            Resource[] copy = (Resource[])this.components.clone();
            for (int i = 0; i < copy.length; ++i) {
                Resource c = copy[i];
                if (!(c instanceof AggregatedResource)) continue;
                AggregatedResource component = (AggregatedResource)c;
                copy[i] = component.apply(strategy);
                changed |= copy[i] != component;
            }
            return changed ? new GroupAggregate(this, copy) : this;
        }
    }

    final <E extends Group<?>> void fillWithChildAggregates(Group<E> children, BiConsumer<E, GroupAggregate> childFiller) {
        assert (this.components.length == children.members.size());
        for (int i = 0; i < this.components.length; ++i) {
            Group member = (Group)children.members.get(i);
            GroupAggregate child = member.prepareAggregate(this.listeners);
            childFiller.accept(member, child);
            this.components[i] = child;
        }
    }

    final void fillWithCoverageComponents(List<GroupByTransform> children, List<SampleDimension> ranges) {
        this.componentsAreLeaves = true;
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = children.get(i).createResource(this.listeners, ranges);
        }
    }

    final Resource simplify(CoverageAggregator aggregator) {
        if (!this.componentsAreLeaves) {
            for (int i = 0; i < this.components.length; ++i) {
                Resource r = this.components[i];
                if (!(r instanceof GroupAggregate)) continue;
                this.components[i] = ((GroupAggregate)r).simplify(aggregator);
            }
        }
        if (this.components.length == 1) {
            return this.configureReplacement(this.components[0]);
        }
        return aggregator.existingAggregate(this.components).orElse(this);
    }

    @Override
    public final List<Resource> components() {
        return UnmodifiableArrayList.wrap((Object[])this.components);
    }

    @Override
    protected void createMetadata(MetadataBuilder builder) throws DataStoreException {
        builder.addExtent(this.getEnvelope().orElse(null), this.listeners);
        if (this.sampleDimensions != null) {
            for (SampleDimension band : this.sampleDimensions) {
                builder.addNewBand(band);
            }
        }
    }
}

