/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import java.lang.management.ManagementFactory;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.sis.setup.About;
import org.apache.sis.system.DaemonThread;
import org.apache.sis.system.SupervisorMBean;
import org.apache.sis.system.SystemListener;
import org.apache.sis.system.Threads;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;

public final class Supervisor
extends StandardMBean
implements SupervisorMBean {
    static final boolean ENABLED = false;
    public static final String NAME = "org.apache.sis:type=Supervisor";
    private static volatile ObjectName name;

    public static synchronized void register() {
        if (name == null) {
            LogRecord record;
            name = ObjectName.WILDCARD;
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName n = new ObjectName(NAME);
                server.registerMBean(new Supervisor(), n);
                name = n;
                return;
            }
            catch (InstanceAlreadyExistsException e) {
                record = Messages.forLocale(null).createLogRecord(Level.CONFIG, (short)1, "MBean", NAME);
            }
            catch (JMException e) {
                record = new LogRecord(Level.WARNING, e.toString());
                record.setThrown(e);
            }
            catch (SecurityException e) {
                record = new LogRecord(Level.CONFIG, e.toString());
            }
            Logging.completeAndLog(SystemListener.LOGGER, Supervisor.class, "register", record);
        }
    }

    static synchronized void unregister() throws JMException {
        ObjectName n = name;
        if (n != null) {
            name = null;
            if (n != ObjectName.WILDCARD) {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(n);
            }
        }
    }

    public Supervisor() throws NotCompliantMBeanException {
        super(SupervisorMBean.class);
    }

    @Override
    protected int getImpact(MBeanOperationInfo info) {
        return 0;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return this.getDescription("supervisor");
    }

    @Override
    protected String getDescription(MBeanFeatureInfo info) {
        return this.getDescription(info.getName());
    }

    @Override
    protected String getDescription(MBeanConstructorInfo info, MBeanParameterInfo param, int sequence) {
        return this.getDescription(this.getParameterName(info, param, sequence));
    }

    @Override
    protected String getParameterName(MBeanConstructorInfo info, MBeanParameterInfo param, int sequence) {
        return "locale";
    }

    private String getDescription(String resourceKey) {
        return ResourceBundle.getBundle("org.apache.sis.system.Descriptions", Locale.getDefault(Locale.Category.DISPLAY), Supervisor.class.getClassLoader()).getString(resourceKey);
    }

    @Override
    public TreeTable configuration(EnumSet<About> sections, Locale locale, TimeZone timezone) {
        return About.configuration(sections, locale, timezone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] warnings(Locale locale) {
        Class<Threads> clazz = Threads.class;
        synchronized (Threads.class) {
            DaemonThread lastCreatedDaemon = Threads.lastCreatedDaemon;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            List<Thread> threads = DaemonThread.listStalledThreads(lastCreatedDaemon);
            if (threads == null) {
                return null;
            }
            String[] warnings = new String[threads.size()];
            Errors resources = Errors.forLocale(locale);
            for (int i = 0; i < warnings.length; ++i) {
                Thread thread = threads.get(i);
                warnings[i] = resources.getString(thread.isAlive() ? (short)154 : 35, thread.getName());
            }
            return warnings;
        }
    }
}

