/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.udp.client;

import io.netty.channel.Channel;
import io.reactivex.netty.client.ClientChannelMetricEventProvider;
import io.reactivex.netty.client.ClientConnectionFactory;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.protocol.udp.client.UdpClientConnection;
import java.net.InetSocketAddress;

class UdpClientConnectionFactory<I, O>
implements ClientConnectionFactory<I, O, UdpClientConnection<I, O>> {
    private final InetSocketAddress receiverAddress;
    private MetricEventsSubject<?> eventsSubject;

    UdpClientConnectionFactory(InetSocketAddress receiverAddress) {
        this.receiverAddress = receiverAddress;
    }

    @Override
    public UdpClientConnection<I, O> newConnection(Channel channel) {
        return UdpClientConnection.create(channel, this.receiverAddress, this.eventsSubject, ClientChannelMetricEventProvider.INSTANCE);
    }

    @Override
    public void useMetricEventsSubject(MetricEventsSubject<?> eventsSubject) {
        this.eventsSubject = eventsSubject;
    }
}

