/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class FourByteNodeId implements Message {

  // Properties.
  protected final short namespaceIndex;
  protected final int identifier;

  public FourByteNodeId(short namespaceIndex, int identifier) {
    super();
    this.namespaceIndex = namespaceIndex;
    this.identifier = identifier;
  }

  public short getNamespaceIndex() {
    return namespaceIndex;
  }

  public int getIdentifier() {
    return identifier;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("FourByteNodeId");

    // Simple Field (namespaceIndex)
    writeSimpleField("namespaceIndex", namespaceIndex, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (identifier)
    writeSimpleField("identifier", identifier, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("FourByteNodeId");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    FourByteNodeId _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (namespaceIndex)
    lengthInBits += 8;

    // Simple field (identifier)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static FourByteNodeId staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("FourByteNodeId");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short namespaceIndex = readSimpleField("namespaceIndex", readUnsignedShort(readBuffer, 8));

    int identifier = readSimpleField("identifier", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("FourByteNodeId");
    // Create the instance
    FourByteNodeId _fourByteNodeId;
    _fourByteNodeId = new FourByteNodeId(namespaceIndex, identifier);
    return _fourByteNodeId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof FourByteNodeId)) {
      return false;
    }
    FourByteNodeId that = (FourByteNodeId) o;
    return (getNamespaceIndex() == that.getNamespaceIndex())
        && (getIdentifier() == that.getIdentifier())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getNamespaceIndex(), getIdentifier());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
