/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetApplicationTagObjectIdentifier is the corresponding interface of BACnetApplicationTagObjectIdentifier
type BACnetApplicationTagObjectIdentifier interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetApplicationTag
	// GetPayload returns Payload (property field)
	GetPayload() BACnetTagPayloadObjectIdentifier
	// GetObjectType returns ObjectType (virtual field)
	GetObjectType() BACnetObjectType
	// GetInstanceNumber returns InstanceNumber (virtual field)
	GetInstanceNumber() uint32
	// IsBACnetApplicationTagObjectIdentifier is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetApplicationTagObjectIdentifier()
	// CreateBuilder creates a BACnetApplicationTagObjectIdentifierBuilder
	CreateBACnetApplicationTagObjectIdentifierBuilder() BACnetApplicationTagObjectIdentifierBuilder
}

// _BACnetApplicationTagObjectIdentifier is the data-structure of this message
type _BACnetApplicationTagObjectIdentifier struct {
	BACnetApplicationTagContract
	Payload BACnetTagPayloadObjectIdentifier
}

var _ BACnetApplicationTagObjectIdentifier = (*_BACnetApplicationTagObjectIdentifier)(nil)
var _ BACnetApplicationTagRequirements = (*_BACnetApplicationTagObjectIdentifier)(nil)

// NewBACnetApplicationTagObjectIdentifier factory function for _BACnetApplicationTagObjectIdentifier
func NewBACnetApplicationTagObjectIdentifier(header BACnetTagHeader, payload BACnetTagPayloadObjectIdentifier) *_BACnetApplicationTagObjectIdentifier {
	if payload == nil {
		panic("payload of type BACnetTagPayloadObjectIdentifier for BACnetApplicationTagObjectIdentifier must not be nil")
	}
	_result := &_BACnetApplicationTagObjectIdentifier{
		BACnetApplicationTagContract: NewBACnetApplicationTag(header),
		Payload:                      payload,
	}
	_result.BACnetApplicationTagContract.(*_BACnetApplicationTag)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetApplicationTagObjectIdentifierBuilder is a builder for BACnetApplicationTagObjectIdentifier
type BACnetApplicationTagObjectIdentifierBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(payload BACnetTagPayloadObjectIdentifier) BACnetApplicationTagObjectIdentifierBuilder
	// WithPayload adds Payload (property field)
	WithPayload(BACnetTagPayloadObjectIdentifier) BACnetApplicationTagObjectIdentifierBuilder
	// WithPayloadBuilder adds Payload (property field) which is build by the builder
	WithPayloadBuilder(func(BACnetTagPayloadObjectIdentifierBuilder) BACnetTagPayloadObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetApplicationTagBuilder
	// Build builds the BACnetApplicationTagObjectIdentifier or returns an error if something is wrong
	Build() (BACnetApplicationTagObjectIdentifier, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetApplicationTagObjectIdentifier
}

// NewBACnetApplicationTagObjectIdentifierBuilder() creates a BACnetApplicationTagObjectIdentifierBuilder
func NewBACnetApplicationTagObjectIdentifierBuilder() BACnetApplicationTagObjectIdentifierBuilder {
	return &_BACnetApplicationTagObjectIdentifierBuilder{_BACnetApplicationTagObjectIdentifier: new(_BACnetApplicationTagObjectIdentifier)}
}

type _BACnetApplicationTagObjectIdentifierBuilder struct {
	*_BACnetApplicationTagObjectIdentifier

	parentBuilder *_BACnetApplicationTagBuilder

	collectedErr []error
}

var _ (BACnetApplicationTagObjectIdentifierBuilder) = (*_BACnetApplicationTagObjectIdentifierBuilder)(nil)

func (b *_BACnetApplicationTagObjectIdentifierBuilder) setParent(contract BACnetApplicationTagContract) {
	b.BACnetApplicationTagContract = contract
	contract.(*_BACnetApplicationTag)._SubType = b._BACnetApplicationTagObjectIdentifier
}

func (b *_BACnetApplicationTagObjectIdentifierBuilder) WithMandatoryFields(payload BACnetTagPayloadObjectIdentifier) BACnetApplicationTagObjectIdentifierBuilder {
	return b.WithPayload(payload)
}

func (b *_BACnetApplicationTagObjectIdentifierBuilder) WithPayload(payload BACnetTagPayloadObjectIdentifier) BACnetApplicationTagObjectIdentifierBuilder {
	b.Payload = payload
	return b
}

func (b *_BACnetApplicationTagObjectIdentifierBuilder) WithPayloadBuilder(builderSupplier func(BACnetTagPayloadObjectIdentifierBuilder) BACnetTagPayloadObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder {
	builder := builderSupplier(b.Payload.CreateBACnetTagPayloadObjectIdentifierBuilder())
	var err error
	b.Payload, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagPayloadObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetApplicationTagObjectIdentifierBuilder) Build() (BACnetApplicationTagObjectIdentifier, error) {
	if b.Payload == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'payload' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetApplicationTagObjectIdentifier.deepCopy(), nil
}

func (b *_BACnetApplicationTagObjectIdentifierBuilder) MustBuild() BACnetApplicationTagObjectIdentifier {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetApplicationTagObjectIdentifierBuilder) Done() BACnetApplicationTagBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetApplicationTagBuilder().(*_BACnetApplicationTagBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetApplicationTagObjectIdentifierBuilder) buildForBACnetApplicationTag() (BACnetApplicationTag, error) {
	return b.Build()
}

func (b *_BACnetApplicationTagObjectIdentifierBuilder) DeepCopy() any {
	_copy := b.CreateBACnetApplicationTagObjectIdentifierBuilder().(*_BACnetApplicationTagObjectIdentifierBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetApplicationTagObjectIdentifierBuilder creates a BACnetApplicationTagObjectIdentifierBuilder
func (b *_BACnetApplicationTagObjectIdentifier) CreateBACnetApplicationTagObjectIdentifierBuilder() BACnetApplicationTagObjectIdentifierBuilder {
	if b == nil {
		return NewBACnetApplicationTagObjectIdentifierBuilder()
	}
	return &_BACnetApplicationTagObjectIdentifierBuilder{_BACnetApplicationTagObjectIdentifier: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetApplicationTagObjectIdentifier) GetParent() BACnetApplicationTagContract {
	return m.BACnetApplicationTagContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetApplicationTagObjectIdentifier) GetPayload() BACnetTagPayloadObjectIdentifier {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetApplicationTagObjectIdentifier) GetObjectType() BACnetObjectType {
	ctx := context.Background()
	_ = ctx
	return CastBACnetObjectType(m.GetPayload().GetObjectType())
}

func (m *_BACnetApplicationTagObjectIdentifier) GetInstanceNumber() uint32 {
	ctx := context.Background()
	_ = ctx
	return uint32(m.GetPayload().GetInstanceNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetApplicationTagObjectIdentifier(structType any) BACnetApplicationTagObjectIdentifier {
	if casted, ok := structType.(BACnetApplicationTagObjectIdentifier); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetApplicationTagObjectIdentifier); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetApplicationTagObjectIdentifier) GetTypeName() string {
	return "BACnetApplicationTagObjectIdentifier"
}

func (m *_BACnetApplicationTagObjectIdentifier) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetApplicationTagContract.(*_BACnetApplicationTag).getLengthInBits(ctx))

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetApplicationTagObjectIdentifier) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetApplicationTagObjectIdentifier) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetApplicationTag) (__bACnetApplicationTagObjectIdentifier BACnetApplicationTagObjectIdentifier, err error) {
	m.BACnetApplicationTagContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetApplicationTagObjectIdentifier"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetApplicationTagObjectIdentifier")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	payload, err := ReadSimpleField[BACnetTagPayloadObjectIdentifier](ctx, "payload", ReadComplex[BACnetTagPayloadObjectIdentifier](BACnetTagPayloadObjectIdentifierParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'payload' field"))
	}
	m.Payload = payload

	objectType, err := ReadVirtualField[BACnetObjectType](ctx, "objectType", (*BACnetObjectType)(nil), payload.GetObjectType())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectType' field"))
	}
	_ = objectType

	instanceNumber, err := ReadVirtualField[uint32](ctx, "instanceNumber", (*uint32)(nil), payload.GetInstanceNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'instanceNumber' field"))
	}
	_ = instanceNumber

	if closeErr := readBuffer.CloseContext("BACnetApplicationTagObjectIdentifier"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetApplicationTagObjectIdentifier")
	}

	return m, nil
}

func (m *_BACnetApplicationTagObjectIdentifier) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetApplicationTagObjectIdentifier) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetApplicationTagObjectIdentifier"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetApplicationTagObjectIdentifier")
		}

		if err := WriteSimpleField[BACnetTagPayloadObjectIdentifier](ctx, "payload", m.GetPayload(), WriteComplex[BACnetTagPayloadObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'payload' field")
		}
		// Virtual field
		objectType := m.GetObjectType()
		_ = objectType
		if _objectTypeErr := writeBuffer.WriteVirtual(ctx, "objectType", m.GetObjectType()); _objectTypeErr != nil {
			return errors.Wrap(_objectTypeErr, "Error serializing 'objectType' field")
		}
		// Virtual field
		instanceNumber := m.GetInstanceNumber()
		_ = instanceNumber
		if _instanceNumberErr := writeBuffer.WriteVirtual(ctx, "instanceNumber", m.GetInstanceNumber()); _instanceNumberErr != nil {
			return errors.Wrap(_instanceNumberErr, "Error serializing 'instanceNumber' field")
		}

		if popErr := writeBuffer.PopContext("BACnetApplicationTagObjectIdentifier"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetApplicationTagObjectIdentifier")
		}
		return nil
	}
	return m.BACnetApplicationTagContract.(*_BACnetApplicationTag).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetApplicationTagObjectIdentifier) IsBACnetApplicationTagObjectIdentifier() {}

func (m *_BACnetApplicationTagObjectIdentifier) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetApplicationTagObjectIdentifier) deepCopy() *_BACnetApplicationTagObjectIdentifier {
	if m == nil {
		return nil
	}
	_BACnetApplicationTagObjectIdentifierCopy := &_BACnetApplicationTagObjectIdentifier{
		m.BACnetApplicationTagContract.(*_BACnetApplicationTag).deepCopy(),
		utils.DeepCopy[BACnetTagPayloadObjectIdentifier](m.Payload),
	}
	_BACnetApplicationTagObjectIdentifierCopy.BACnetApplicationTagContract.(*_BACnetApplicationTag)._SubType = m
	return _BACnetApplicationTagObjectIdentifierCopy
}

func (m *_BACnetApplicationTagObjectIdentifier) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
