/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.impl;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.jaas.modules.EncryptionService;
import org.apache.karaf.jaas.modules.encryption.BasicEncryptionService;
import org.apache.karaf.jaas.modules.impl.KarafRealm;
import org.apache.karaf.jaas.modules.ldap.LDAPCache;
import org.apache.karaf.jaas.modules.properties.AutoEncryptionSupport;
import org.apache.karaf.jaas.modules.properties.PropertiesBackingEngineFactory;
import org.apache.karaf.jaas.modules.publickey.PublickeyBackingEngineFactory;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;

@Managed(value="org.apache.karaf.jaas")
@Services(provides={@ProvideService(value=JaasRealm.class), @ProvideService(value=BackingEngineFactory.class)})
public class Activator
extends BaseActivator
implements ManagedService {
    private static final String ENCRYPTION_NAME = "encryption.name";
    private static final String ENCRYPTION_ENABLED = "encryption.enabled";
    private static final String ENCRYPTION_PREFIX = "encryption.prefix";
    private static final String ENCRYPTION_SUFFIX = "encryption.suffix";
    private static final String ENCRYPTION_ALGORITHM = "encryption.algorithm";
    private static final String ENCRYPTION_ENCODING = "encryption.encoding";
    private static final String EVENTADMIN_ENABLED = "eventadmin.enabled";
    private KarafRealm karafRealm;
    private AutoEncryptionSupport autoEncryptionSupport;

    @Override
    protected void doOpen() throws Exception {
        super.doOpen();
        this.register(BackingEngineFactory.class, new PropertiesBackingEngineFactory());
        this.register(BackingEngineFactory.class, new PublickeyBackingEngineFactory());
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("service.ranking", -1);
        props.put("name", "basic");
        this.register(EncryptionService.class, new BasicEncryptionService(), props);
        Map<String, Object> config = this.getConfig();
        this.karafRealm = new KarafRealm(this.bundleContext, config);
        this.register(JaasRealm.class, this.karafRealm);
        if (Boolean.parseBoolean((String)config.get(ENCRYPTION_ENABLED))) {
            this.autoEncryptionSupport = new AutoEncryptionSupport(config);
        }
    }

    @Override
    protected void doStop() {
        if (this.autoEncryptionSupport != null) {
            this.autoEncryptionSupport.close();
        }
        super.doStop();
        LDAPCache.clear();
    }

    @Override
    protected void reconfigure() {
        Map<String, Object> config = this.getConfig();
        if (this.karafRealm != null) {
            this.karafRealm.updated(config);
        }
        if (this.autoEncryptionSupport != null) {
            this.autoEncryptionSupport.close();
            this.autoEncryptionSupport = null;
        }
        if (Boolean.parseBoolean((String)config.get(ENCRYPTION_ENABLED))) {
            this.autoEncryptionSupport = new AutoEncryptionSupport(config);
        }
    }

    private Map<String, Object> getConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        this.populate(config, "detailed.login.exception", "false");
        this.populate(config, ENCRYPTION_NAME, "basic");
        this.populate(config, ENCRYPTION_ENABLED, "false");
        this.populate(config, ENCRYPTION_PREFIX, "{CRYPT}");
        this.populate(config, ENCRYPTION_SUFFIX, "{CRYPT}");
        this.populate(config, ENCRYPTION_ALGORITHM, "MD5");
        this.populate(config, ENCRYPTION_ENCODING, "hexadecimal");
        this.populate(config, EVENTADMIN_ENABLED, "true");
        this.populate(config, "audit.file.enabled", "false");
        this.populate(config, "audit.file.file", System.getProperty("karaf.data") + "/security/audit.log");
        this.populate(config, "audit.log.enabled", "false");
        this.populate(config, "audit.log.logger", "org.apache.karaf.jaas.modules.audit.LogAuditLoginModule");
        this.populate(config, "audit.log.level", "info");
        this.populate(config, "audit.eventadmin.enabled", "true");
        this.populate(config, "audit.eventadmin.topic", "org/apache/karaf/login");
        config.put(BundleContext.class.getName(), this.bundleContext);
        return config;
    }

    private void populate(Map<String, Object> map, String key, String def) {
        map.put(key, this.getString(key, def));
    }
}

