/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacketI;

public class SessionSendLargeMessage
extends PacketImpl
implements MessagePacketI {
    private Message largeMessage;

    public SessionSendLargeMessage(Message largeMessage) {
        super((byte)72);
        this.largeMessage = largeMessage;
    }

    public Message getLargeMessage() {
        return this.largeMessage;
    }

    @Override
    public MessagePacketI replaceMessage(Message message) {
        this.largeMessage = message;
        return this;
    }

    @Override
    public Message getMessage() {
        return this.largeMessage;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        ((CoreMessage)this.largeMessage).encodeHeadersAndProperties(buffer.byteBuf());
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        ((CoreMessage)this.largeMessage).decodeHeadersAndProperties(buffer.byteBuf());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.largeMessage == null ? 0 : this.largeMessage.hashCode());
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", largeMessage=" + String.valueOf(this.largeMessage));
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionSendLargeMessage)) {
            return false;
        }
        SessionSendLargeMessage other = (SessionSendLargeMessage)obj;
        return !(this.largeMessage == null ? other.largeMessage != null : !this.largeMessage.equals(other.largeMessage));
    }
}

