/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.policies.local;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.MacroExpand;
import org.apache.james.jspf.core.SPF1Record;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.policies.PolicyPostFilter;
import org.apache.james.jspf.terms.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExplanationPolicy
implements PolicyPostFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExplanationPolicy.class);
    private static final String ATTRIBUTE_DEFAULT_EXPLANATION_POLICY_EXPLANATION = "DefaultExplanationPolicy.explanation";
    private String defExplanation;
    private MacroExpand macroExpand;

    public DefaultExplanationPolicy(String explanation, MacroExpand macroExpand) {
        this.defExplanation = explanation;
        this.macroExpand = macroExpand;
    }

    @Override
    public SPF1Record getSPFRecord(String currentDomain, SPF1Record spfRecord) throws PermErrorException, TempErrorException, NoneException, NeutralException {
        if (spfRecord == null) {
            return null;
        }
        spfRecord.getModifiers().add(new DefaultExplanationChecker());
        return spfRecord;
    }

    private final class DefaultExplanationChecker
    implements Modifier {
        private SPFChecker explanationCheckr;

        private DefaultExplanationChecker() {
            this.explanationCheckr = new ExplanationChecker();
        }

        @Override
        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            if ("-".equals(spfData.getCurrentResult()) && (spfData.getExplanation() == null || spfData.getExplanation().equals(""))) {
                String explanation = DefaultExplanationPolicy.this.defExplanation == null ? "http://www.openspf.org/why.html?sender=%{S}&ip=%{I}" : DefaultExplanationPolicy.this.defExplanation;
                spfData.setAttribute(DefaultExplanationPolicy.ATTRIBUTE_DEFAULT_EXPLANATION_POLICY_EXPLANATION, explanation);
                spfData.pushChecker(this.explanationCheckr);
                return DefaultExplanationPolicy.this.macroExpand.checkExpand(explanation, spfData, true);
            }
            return null;
        }

        public String toString() {
            if (DefaultExplanationPolicy.this.defExplanation == null) {
                return "defaultExplanation";
            }
            return "defaultExplanation=" + DefaultExplanationPolicy.this.defExplanation;
        }

        @Override
        public boolean enforceSingleInstance() {
            return false;
        }
    }

    private final class ExplanationChecker
    implements SPFChecker {
        private ExplanationChecker() {
        }

        @Override
        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            String attExplanation = (String)spfData.getAttribute(DefaultExplanationPolicy.ATTRIBUTE_DEFAULT_EXPLANATION_POLICY_EXPLANATION);
            try {
                String explanation = DefaultExplanationPolicy.this.macroExpand.expand(attExplanation, spfData, true);
                spfData.setExplanation(explanation);
            }
            catch (PermErrorException e) {
                LOGGER.debug("Invalid defaulfExplanation: {}", (Object)attExplanation);
            }
            return null;
        }
    }
}

