/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.user.ldap.ReadOnlyLDAPGroupRestriction;

public class LdapRepositoryConfiguration {
    public static final String SUPPORTS_VIRTUAL_HOSTING = "supportsVirtualHosting";
    public static final String SUPPORTS_VIRTUAL_HOSTING_FALLBACK = "enableVirtualHosting";
    private static final int NO_CONNECTION_TIMEOUT = 0;
    private static final int NO_READ_TIME_OUT = 0;
    private static final boolean ENABLE_VIRTUAL_HOSTING = true;
    private static final ReadOnlyLDAPGroupRestriction NO_RESTRICTION = new ReadOnlyLDAPGroupRestriction(null);
    private static final String NO_FILTER = null;
    private static final Optional<String> NO_ADMINISTRATOR_ID = Optional.empty();
    private static final int DEFAULT_POOL_SIZE = 4;
    private static final int DEFAULT_MAX_WAIT_TIME_MILLIS = 1000;
    private final List<URI> ldapHosts;
    private final String principal;
    private final String credentials;
    private final String userBase;
    private final String userListBase;
    private final String userIdAttribute;
    private final Optional<String> usernameAttribute;
    private final Optional<String> resolveLocalPartAttribute;
    private final String userObjectClass;
    private final int connectionTimeout;
    private final int readTimeout;
    private final boolean supportsVirtualHosting;
    private final int poolSize;
    private final int maxWaitTime;
    private final ReadOnlyLDAPGroupRestriction restriction;
    private final String filter;
    private final Optional<Username> administratorId;
    private final boolean trustAllCerts;
    private final ImmutableMap<Domain, String> perDomainBaseDN;

    public static Builder builder() {
        return new Builder();
    }

    public static LdapRepositoryConfiguration from(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        List ldapHosts = (List)Splitter.on((String)",").splitToList((CharSequence)Optional.ofNullable(configuration.getString("[@ldapHosts]", null)).orElse(configuration.getString("[@ldapHost]", "")).trim()).stream().map(Throwing.function(URI::new)).collect(ImmutableList.toImmutableList());
        String principal = configuration.getString("[@principal]", "");
        String credentials = configuration.getString("[@credentials]", "");
        String userBase = configuration.getString("[@userBase]");
        String userListBase = Optional.ofNullable(configuration.getString("[@userListBase]", null)).orElse(userBase);
        String userIdAttribute = configuration.getString("[@userIdAttribute]");
        Optional<String> resolveLocalPartAttribute = Optional.ofNullable(configuration.getString("[@resolveLocalPartAttribute]", null));
        Optional<String> usernameAttribute = Optional.ofNullable(configuration.getString("[@usernameAttribute]", null));
        String userObjectClass = configuration.getString("[@userObjectClass]");
        int connectionTimeout = configuration.getInt("[@connectionTimeout]", 0);
        int readTimeout = configuration.getInt("[@readTimeout]", 0);
        boolean supportsVirtualHostingFallback = configuration.getBoolean(SUPPORTS_VIRTUAL_HOSTING_FALLBACK, false);
        boolean supportsVirtualHosting = configuration.getBoolean(SUPPORTS_VIRTUAL_HOSTING, supportsVirtualHostingFallback);
        HierarchicalConfiguration restrictionConfig = null;
        if (configuration.containsKey("restriction[@memberAttribute]")) {
            restrictionConfig = configuration.configurationAt("restriction");
        }
        ReadOnlyLDAPGroupRestriction restriction = new ReadOnlyLDAPGroupRestriction((HierarchicalConfiguration<ImmutableNode>)restrictionConfig);
        String filter = configuration.getString("[@filter]");
        Boolean trustAllCerts = configuration.getBoolean("[@trustAllCerts]", false);
        Optional<String> administratorId = Optional.ofNullable(configuration.getString("[@administratorId]"));
        int poolSize = Optional.ofNullable(configuration.getInteger("[@poolSize]", null)).orElse(4);
        int maxWaitTime = Optional.ofNullable(configuration.getInteger("[@maxWaitTime]", null)).orElse(1000);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (configuration.getNodeModel().getInMemoryRepresentation().getChildren().stream().anyMatch(n -> n.getNodeName().equals("domains"))) {
            HierarchicalConfiguration domains = configuration.configurationAt("domains");
            Iterator keys = domains.getKeys();
            while (keys.hasNext()) {
                String next = (String)keys.next();
                builder.put((Object)Domain.of((String)next), (Object)domains.getString(next));
            }
        }
        return new LdapRepositoryConfiguration(ldapHosts, principal, credentials, userBase, userListBase, userIdAttribute, resolveLocalPartAttribute, usernameAttribute, userObjectClass, connectionTimeout, readTimeout, supportsVirtualHosting, poolSize, maxWaitTime, restriction, filter, administratorId, trustAllCerts, (ImmutableMap<Domain, String>)builder.build());
    }

    private LdapRepositoryConfiguration(List<URI> ldapHosts, String principal, String credentials, String userBase, String userListBase, String userIdAttribute, Optional<String> resolveLocalPartAttribute, Optional<String> usernameAttribute, String userObjectClass, int connectionTimeout, int readTimeout, boolean supportsVirtualHosting, int poolSize, int maxWaitTime, ReadOnlyLDAPGroupRestriction restriction, String filter, Optional<String> administratorId, boolean trustAllCerts, ImmutableMap<Domain, String> perDomainBaseDN) throws ConfigurationException {
        this.ldapHosts = ldapHosts;
        this.principal = principal;
        this.credentials = credentials;
        this.userBase = userBase;
        this.userListBase = userListBase;
        this.userIdAttribute = userIdAttribute;
        this.resolveLocalPartAttribute = resolveLocalPartAttribute;
        this.usernameAttribute = usernameAttribute;
        this.userObjectClass = userObjectClass;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.supportsVirtualHosting = supportsVirtualHosting;
        this.poolSize = poolSize;
        this.maxWaitTime = maxWaitTime;
        this.restriction = restriction;
        this.filter = filter;
        this.administratorId = administratorId.map(Username::of);
        this.trustAllCerts = trustAllCerts;
        this.perDomainBaseDN = perDomainBaseDN;
        this.checkState();
    }

    private void checkState() throws ConfigurationException {
        if (this.userBase == null) {
            throw new ConfigurationException("[@userBase] is mandatory");
        }
        if (this.userIdAttribute == null) {
            throw new ConfigurationException("[@userIdAttribute] is mandatory");
        }
        if (this.userObjectClass == null) {
            throw new ConfigurationException("[@userObjectClass] is mandatory");
        }
    }

    public List<URI> getLdapHosts() {
        return this.ldapHosts;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public String getUserListBase() {
        return this.userListBase;
    }

    public String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    public Optional<String> getResolveLocalPartAttribute() {
        return this.resolveLocalPartAttribute;
    }

    public Optional<String> getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean supportsVirtualHosting() {
        return this.supportsVirtualHosting;
    }

    public ReadOnlyLDAPGroupRestriction getRestriction() {
        return this.restriction;
    }

    public String getFilter() {
        return this.filter;
    }

    public Optional<Username> getAdministratorId() {
        return this.administratorId;
    }

    public boolean isTrustAllCerts() {
        return this.trustAllCerts;
    }

    public ImmutableMap<Domain, String> getPerDomainBaseDN() {
        return this.perDomainBaseDN;
    }

    public String[] getReturnedAttributes() {
        if (this.getUsernameAttribute().isPresent()) {
            return new String[]{this.getUserIdAttribute(), this.getUsernameAttribute().get()};
        }
        return new String[]{this.getUserIdAttribute()};
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public final boolean equals(Object o) {
        if (o instanceof LdapRepositoryConfiguration) {
            LdapRepositoryConfiguration that = (LdapRepositoryConfiguration)o;
            return Objects.equals(this.connectionTimeout, that.connectionTimeout) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.supportsVirtualHosting, that.supportsVirtualHosting) && Objects.equals(this.ldapHosts, that.ldapHosts) && Objects.equals(this.principal, that.principal) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.userBase, that.userBase) && Objects.equals(this.userListBase, that.userListBase) && Objects.equals(this.userIdAttribute, that.userIdAttribute) && Objects.equals(this.resolveLocalPartAttribute, that.resolveLocalPartAttribute) && Objects.equals(this.userObjectClass, that.userObjectClass) && Objects.equals(this.restriction, that.restriction) && Objects.equals(this.filter, that.filter) && Objects.equals(this.poolSize, that.poolSize) && Objects.equals(this.administratorId, that.administratorId) && Objects.equals(this.trustAllCerts, that.trustAllCerts) && Objects.equals(this.usernameAttribute, that.usernameAttribute) && Objects.equals(this.perDomainBaseDN, that.perDomainBaseDN);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.ldapHosts, this.principal, this.credentials, this.userBase, this.userListBase, this.userIdAttribute, this.resolveLocalPartAttribute, this.userObjectClass, this.connectionTimeout, this.readTimeout, this.supportsVirtualHosting, this.restriction, this.filter, this.administratorId, this.poolSize, this.trustAllCerts, this.perDomainBaseDN, this.usernameAttribute);
    }

    public static class Builder {
        private Optional<List<URI>> ldapHosts = Optional.empty();
        private Optional<String> principal = Optional.empty();
        private Optional<String> credentials = Optional.empty();
        private Optional<String> userBase = Optional.empty();
        private Optional<String> userListBase = Optional.empty();
        private Optional<String> userIdAttribute = Optional.empty();
        private Optional<String> resolveLocalPartAttribute = Optional.empty();
        private Optional<String> userObjectClass = Optional.empty();
        private Optional<String> usernameAttribute = Optional.empty();
        private Optional<Integer> poolSize = Optional.empty();
        private Optional<Integer> maxWaitTime;
        private Optional<Boolean> trustAllCerts = Optional.empty();
        private ImmutableMap.Builder<Domain, String> perDomainBaseDN = ImmutableMap.builder();

        public Builder() {
            this.maxWaitTime = Optional.empty();
        }

        public Builder ldapHosts(List<URI> ldapHosts) {
            this.ldapHosts = Optional.of(ldapHosts);
            return this;
        }

        public Builder principal(String principal) {
            this.principal = Optional.of(principal);
            return this;
        }

        public Builder credentials(String credentials) {
            this.credentials = Optional.of(credentials);
            return this;
        }

        public Builder userBase(String userBase) {
            this.userBase = Optional.of(userBase);
            return this;
        }

        public Builder userListBase(String userBase) {
            this.userListBase = Optional.of(userBase);
            return this;
        }

        public Builder userIdAttribute(String userIdAttribute) {
            this.userIdAttribute = Optional.of(userIdAttribute);
            return this;
        }

        public Builder resolveLocalPartAttribute(String resolveLocalPartAttribute) {
            this.resolveLocalPartAttribute = Optional.of(resolveLocalPartAttribute);
            return this;
        }

        public Builder userObjectClass(String userObjectClass) {
            this.userObjectClass = Optional.of(userObjectClass);
            return this;
        }

        public Builder poolSize(int poolSize) {
            this.poolSize = Optional.of(poolSize);
            return this;
        }

        public Builder maxWaitTime(int waitTimeMillis) {
            this.maxWaitTime = Optional.of(waitTimeMillis);
            return this;
        }

        public Builder trustAllCerts(boolean trustAllCerts) {
            this.trustAllCerts = Optional.of(trustAllCerts);
            return this;
        }

        public Builder addPerDomainDN(Domain domain, String dn) {
            this.perDomainBaseDN.put((Object)domain, (Object)dn);
            return this;
        }

        public LdapRepositoryConfiguration build() throws ConfigurationException {
            Preconditions.checkState((boolean)this.ldapHosts.isPresent(), (Object)"'ldapHosts' is mandatory");
            Preconditions.checkState((boolean)this.principal.isPresent(), (Object)"'principal' is mandatory");
            Preconditions.checkState((boolean)this.credentials.isPresent(), (Object)"'credentials' is mandatory");
            Preconditions.checkState((boolean)this.userBase.isPresent(), (Object)"'userBase' is mandatory");
            Preconditions.checkState((boolean)this.userIdAttribute.isPresent(), (Object)"'userIdAttribute' is mandatory");
            Preconditions.checkState((boolean)this.userObjectClass.isPresent(), (Object)"'userObjectClass' is mandatory");
            return new LdapRepositoryConfiguration(this.ldapHosts.get(), this.principal.get(), this.credentials.get(), this.userBase.get(), this.userListBase.orElse(this.userBase.get()), this.userIdAttribute.get(), this.resolveLocalPartAttribute, this.usernameAttribute, this.userObjectClass.get(), 0, 0, false, this.poolSize.orElse(4), this.maxWaitTime.orElse(1000), NO_RESTRICTION, NO_FILTER, NO_ADMINISTRATOR_ID, this.trustAllCerts.orElse(false), (ImmutableMap<Domain, String>)this.perDomainBaseDN.build());
        }
    }
}

