/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.time.Clock;
import java.util.Set;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.cassandra.DeleteMessageListener;
import org.apache.james.mailbox.cassandra.mail.ACLMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraAnnotationMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraApplicableFlagDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentDAOV2;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraFirstUnseenDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraIndexTableHandler;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxCounterDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxPathV3DAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxRecentsDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadLookupDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraUserMailboxRightsDAO;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersService;
import org.apache.james.mailbox.cassandra.user.CassandraSubscriptionMapper;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.AttachmentIdAssignationStrategy;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class CassandraMailboxSessionMapperFactory
extends MailboxSessionMapperFactory
implements AttachmentMapperFactory {
    private final UidProvider uidProvider;
    private final ModSeqProvider modSeqProvider;
    private final CassandraThreadDAO threadDAO;
    private final CassandraThreadLookupDAO threadLookupDAO;
    private final CassandraMessageDAOV3 messageDAOV3;
    private final CassandraMessageIdDAO messageIdDAO;
    private final CassandraMessageIdToImapUidDAO imapUidDAO;
    private final CassandraMailboxCounterDAO mailboxCounterDAO;
    private final CassandraMailboxRecentsDAO mailboxRecentsDAO;
    private final CassandraFirstUnseenDAO firstUnseenDAO;
    private final CassandraApplicableFlagDAO applicableFlagDAO;
    private final CassandraAttachmentDAOV2 attachmentDAOV2;
    private final CassandraDeletedMessageDAO deletedMessageDAO;
    private final BlobStore blobStore;
    private final ACLMapper aclMapper;
    private final CassandraUserMailboxRightsDAO userMailboxRightsDAO;
    private final CassandraConfiguration cassandraConfiguration;
    private final CassandraMailboxMapper cassandraMailboxMapper;
    private final CassandraSubscriptionMapper cassandraSubscriptionMapper;
    private final CassandraAttachmentMapper cassandraAttachmentMapper;
    private final CassandraMessageMapper cassandraMessageMapper;
    private final CassandraMessageIdMapper cassandraMessageIdMapper;
    private final CassandraAnnotationMapper cassandraAnnotationMapper;

    @Inject
    public CassandraMailboxSessionMapperFactory(UidProvider uidProvider, ModSeqProvider modSeqProvider, CqlSession session, CassandraThreadDAO threadDAO, CassandraThreadLookupDAO threadLookupDAO, CassandraMessageDAOV3 messageDAOV3, CassandraMessageIdDAO messageIdDAO, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMailboxCounterDAO mailboxCounterDAO, CassandraMailboxRecentsDAO mailboxRecentsDAO, CassandraMailboxDAO mailboxDAO, CassandraMailboxPathV3DAO mailboxPathV3DAO, CassandraFirstUnseenDAO firstUnseenDAO, CassandraApplicableFlagDAO applicableFlagDAO, CassandraAttachmentDAOV2 attachmentDAOV2, CassandraDeletedMessageDAO deletedMessageDAO, BlobStore blobStore, ACLMapper aclMapper, CassandraUserMailboxRightsDAO userMailboxRightsDAO, RecomputeMailboxCountersService recomputeMailboxCountersService, CassandraConfiguration cassandraConfiguration, BatchSizes batchSizes, AttachmentIdAssignationStrategy attachmentIdAssignationStrategy, Clock clock) {
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
        this.threadDAO = threadDAO;
        this.threadLookupDAO = threadLookupDAO;
        this.messageDAOV3 = messageDAOV3;
        this.messageIdDAO = messageIdDAO;
        this.imapUidDAO = imapUidDAO;
        this.mailboxCounterDAO = mailboxCounterDAO;
        this.mailboxRecentsDAO = mailboxRecentsDAO;
        this.firstUnseenDAO = firstUnseenDAO;
        this.attachmentDAOV2 = attachmentDAOV2;
        this.deletedMessageDAO = deletedMessageDAO;
        this.applicableFlagDAO = applicableFlagDAO;
        this.blobStore = blobStore;
        this.aclMapper = aclMapper;
        this.userMailboxRightsDAO = userMailboxRightsDAO;
        this.cassandraConfiguration = cassandraConfiguration;
        CassandraIndexTableHandler indexTableHandler = new CassandraIndexTableHandler(mailboxRecentsDAO, mailboxCounterDAO, firstUnseenDAO, applicableFlagDAO, deletedMessageDAO);
        this.cassandraMailboxMapper = new CassandraMailboxMapper(mailboxDAO, mailboxPathV3DAO, userMailboxRightsDAO, aclMapper, cassandraConfiguration);
        this.cassandraSubscriptionMapper = new CassandraSubscriptionMapper(session);
        this.cassandraAttachmentMapper = new CassandraAttachmentMapper(attachmentDAOV2, blobStore, attachmentIdAssignationStrategy);
        this.cassandraMessageMapper = new CassandraMessageMapper(uidProvider, modSeqProvider, this.cassandraAttachmentMapper, messageDAOV3, messageIdDAO, imapUidDAO, mailboxCounterDAO, mailboxRecentsDAO, applicableFlagDAO, indexTableHandler, firstUnseenDAO, deletedMessageDAO, blobStore, cassandraConfiguration, batchSizes, recomputeMailboxCountersService, clock);
        this.cassandraMessageIdMapper = new CassandraMessageIdMapper(this.cassandraMailboxMapper, mailboxDAO, this.cassandraAttachmentMapper, imapUidDAO, messageIdDAO, messageDAOV3, indexTableHandler, modSeqProvider, blobStore, cassandraConfiguration, batchSizes, clock);
        this.cassandraAnnotationMapper = new CassandraAnnotationMapper(session);
    }

    public CassandraMessageMapper createMessageMapper(MailboxSession mailboxSession) {
        return this.cassandraMessageMapper;
    }

    public MessageIdMapper createMessageIdMapper(MailboxSession mailboxSession) {
        return this.cassandraMessageIdMapper;
    }

    public MailboxMapper createMailboxMapper(MailboxSession mailboxSession) {
        return this.cassandraMailboxMapper;
    }

    public CassandraAttachmentMapper createAttachmentMapper(MailboxSession mailboxSession) {
        return this.cassandraAttachmentMapper;
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession mailboxSession) {
        return this.cassandraSubscriptionMapper;
    }

    public ModSeqProvider getModSeqProvider(MailboxSession session) {
        return this.modSeqProvider;
    }

    public UidProvider getUidProvider(MailboxSession session) {
        return this.uidProvider;
    }

    public AnnotationMapper createAnnotationMapper(MailboxSession mailboxSession) {
        return this.cassandraAnnotationMapper;
    }

    public AttachmentMapper getAttachmentMapper(MailboxSession session) {
        return this.cassandraAttachmentMapper;
    }

    public MessageMapper getMessageMapper(MailboxSession session) {
        return this.cassandraMessageMapper;
    }

    public MessageIdMapper getMessageIdMapper(MailboxSession session) {
        return this.cassandraMessageIdMapper;
    }

    public AnnotationMapper getAnnotationMapper(MailboxSession session) {
        return this.cassandraAnnotationMapper;
    }

    public MailboxMapper getMailboxMapper(MailboxSession session) {
        return this.cassandraMailboxMapper;
    }

    public SubscriptionMapper getSubscriptionMapper(MailboxSession session) {
        return this.cassandraSubscriptionMapper;
    }

    public void endProcessingRequest(MailboxSession session) {
    }

    public DeleteMessageListener deleteMessageListener() {
        return new DeleteMessageListener(this.threadDAO, this.threadLookupDAO, this.imapUidDAO, this.messageIdDAO, this.messageDAOV3, this.attachmentDAOV2, this.aclMapper, this.userMailboxRightsDAO, this.applicableFlagDAO, this.firstUnseenDAO, this.deletedMessageDAO, this.mailboxCounterDAO, this.mailboxRecentsDAO, this.blobStore, this.cassandraConfiguration, (Set<DeleteMessageListener.DeletionCallback>)ImmutableSet.of());
    }
}

