/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.core;

import com.fasterxml.jackson.core.JsonParseException;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import org.apache.james.jmap.core.MaxCallsInRequest$;
import org.apache.james.jmap.core.MaxSizeRequest$;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.RequestLevelErrorType$;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.routes.RequestSizeExceeded;
import org.apache.james.jmap.routes.StreamConstraintsExceptionWithInput;
import org.apache.james.jmap.routes.TooManyCallsInRequest;
import org.apache.james.jmap.routes.UnsupportedCapabilitiesException;
import org.apache.james.util.MDCStructuredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.channel.AbortedException;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.runtime.ModuleSerializationProxy;

public final class ProblemDetails$
implements Serializable {
    public static final ProblemDetails$ MODULE$ = new ProblemDetails$();
    private static final Logger LOGGER = LoggerFactory.getLogger(ProblemDetails.class);

    public String $lessinit$greater$default$1() {
        return RequestLevelErrorType$.MODULE$.DEFAULT_ERROR_TYPE();
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Logger LOGGER() {
        return LOGGER;
    }

    public ProblemDetails forThrowable(Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof AbortedException) {
            AbortedException abortedException = (AbortedException)throwable2;
            this.LOGGER().info("The connection was aborted: {}", (Object)abortedException.getMessage());
            HttpResponseStatus x$1 = HttpResponseStatus.REQUEST_TIMEOUT;
            String x$2 = abortedException.getMessage();
            String x$3 = this.apply$default$1();
            Option<String> x$4 = this.apply$default$3();
            return new ProblemDetails(x$3, x$1, x$4, x$2);
        }
        if (throwable2 instanceof IllegalArgumentException) {
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable2;
            this.LOGGER().info("The request was successfully parsed as JSON but did not match the type signature of the Request object: {}", (Object)illegalArgumentException.getMessage());
            return this.notRequestProblem("The request was successfully parsed as JSON but did not match the type signature of the Request object: " + illegalArgumentException.getMessage());
        }
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            this.LOGGER().info("Unauthorized", (Throwable)unauthorizedException);
            HttpResponseStatus x$5 = HttpResponseStatus.UNAUTHORIZED;
            String x$6 = unauthorizedException.getMessage();
            String x$7 = this.apply$default$1();
            Option<String> x$8 = this.apply$default$3();
            return new ProblemDetails(x$7, x$5, x$8, x$6);
        }
        if (throwable2 instanceof JsonParseException) {
            JsonParseException jsonParseException = (JsonParseException)throwable2;
            this.LOGGER().info("The content type of the request was not application/json or the request did not parse as I-JSON: {}", (Object)jsonParseException.getMessage());
            return this.notJSONProblem("The content type of the request was not application/json or the request did not parse as I-JSON: " + jsonParseException.getMessage());
        }
        if (throwable2 instanceof UnsupportedCapabilitiesException) {
            UnsupportedCapabilitiesException unsupportedCapabilitiesException = (UnsupportedCapabilitiesException)throwable2;
            this.LOGGER().info("The request used unsupported capabilities: " + unsupportedCapabilitiesException.capabilities());
            return this.unknownCapabilityProblem("The request used unsupported capabilities: " + unsupportedCapabilitiesException.capabilities());
        }
        if (throwable2 instanceof StreamConstraintsExceptionWithInput) {
            StreamConstraintsExceptionWithInput streamConstraintsExceptionWithInput = (StreamConstraintsExceptionWithInput)throwable2;
            MDCStructuredLogger.forLogger((Logger)this.LOGGER()).field("input", new String(streamConstraintsExceptionWithInput.input()).substring(0, 4096)).log(logger -> logger.warn("Stream constraint had been violated", (Throwable)streamConstraintsExceptionWithInput.cause()));
            return this.notRequestProblem("The request violated stream constraints: " + streamConstraintsExceptionWithInput.getMessage());
        }
        if (throwable2 instanceof RequestSizeExceeded) {
            RequestSizeExceeded requestSizeExceeded = (RequestSizeExceeded)throwable2;
            String message = "Request size is exceeded. Was " + requestSizeExceeded.input().length + " but maximum allowed is " + MaxSizeRequest$.MODULE$.DEFAULT();
            MDCStructuredLogger.forLogger((Logger)this.LOGGER()).field("input", new String(requestSizeExceeded.input()).substring(0, 4096)).log(logger -> logger.warn(message));
            return new ProblemDetails(RequestLevelErrorType$.MODULE$.LIMIT(), HttpResponseStatus.BAD_REQUEST, (Option<String>)new Some((Object)"maxSizeRequest"), message);
        }
        if (throwable2 instanceof TooManyCallsInRequest) {
            TooManyCallsInRequest tooManyCallsInRequest = (TooManyCallsInRequest)throwable2;
            String message = "Request call count limit is exceeded. Was " + tooManyCallsInRequest.requestObject().methodCalls().length() + " but maximum allowed is " + MaxCallsInRequest$.MODULE$.DEFAULT();
            this.LOGGER().warn(message, (Throwable)tooManyCallsInRequest);
            return new ProblemDetails(RequestLevelErrorType$.MODULE$.LIMIT(), HttpResponseStatus.BAD_REQUEST, (Option<String>)new Some((Object)"maxCallsInRequest"), message);
        }
        this.LOGGER().error("Unexpected error upon API request", throwable2);
        HttpResponseStatus x$9 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        String x$10 = throwable2.getMessage();
        String x$11 = this.apply$default$1();
        Option<String> x$12 = this.apply$default$3();
        return new ProblemDetails(x$11, x$9, x$12, x$10);
    }

    public ProblemDetails notRequestProblem(String message) {
        return new ProblemDetails(RequestLevelErrorType$.MODULE$.NOT_REQUEST(), HttpResponseStatus.BAD_REQUEST, (Option<String>)None$.MODULE$, message);
    }

    public ProblemDetails notJSONProblem(String message) {
        return new ProblemDetails(RequestLevelErrorType$.MODULE$.NOT_JSON(), HttpResponseStatus.BAD_REQUEST, (Option<String>)None$.MODULE$, message);
    }

    public ProblemDetails unknownCapabilityProblem(String message) {
        return new ProblemDetails(RequestLevelErrorType$.MODULE$.UNKNOWN_CAPABILITY(), HttpResponseStatus.BAD_REQUEST, (Option<String>)None$.MODULE$, message);
    }

    public ProblemDetails invalidResultReference(String message) {
        return new ProblemDetails(RequestLevelErrorType$.MODULE$.UNKNOWN_CAPABILITY(), HttpResponseStatus.BAD_REQUEST, (Option<String>)None$.MODULE$, message);
    }

    public ProblemDetails apply(String type, HttpResponseStatus status, Option<String> limit, String detail) {
        return new ProblemDetails(type, status, limit, detail);
    }

    public String apply$default$1() {
        return RequestLevelErrorType$.MODULE$.DEFAULT_ERROR_TYPE();
    }

    public Option<String> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<Tuple4<Refined<String, string.Uri>, HttpResponseStatus, Option<String>, String>> unapply(ProblemDetails x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)new Refined((Object)x$0.type()), (Object)x$0.status(), x$0.limit(), (Object)x$0.detail()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProblemDetails$.class);
    }

    private ProblemDetails$() {
    }
}

